/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.processvariable;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.textfield.IntegerField;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.upload.receivers.MemoryBuffer;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.router.Route;
import io.jmix.core.CoreProperties;
import io.jmix.core.FileStorageException;
import io.jmix.core.LoadContext;
import io.jmix.core.Metadata;
import io.jmix.core.SaveContext;
import io.jmix.core.metamodel.datatype.DatatypeRegistry;
import io.jmix.flowui.Actions;
import io.jmix.flowui.UiComponents;
import io.jmix.flowui.component.combobox.JmixComboBox;
import io.jmix.flowui.component.datetimepicker.TypedDateTimePicker;
import io.jmix.flowui.component.formlayout.JmixFormLayout;
import io.jmix.flowui.component.select.JmixSelect;
import io.jmix.flowui.component.textarea.JmixTextArea;
import io.jmix.flowui.component.textfield.TypedTextField;
import io.jmix.flowui.component.upload.FileUploadField;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.kit.component.upload.event.FileUploadSucceededEvent;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.view.DefaultMainViewParent;
import io.jmix.flowui.view.DialogMode;
import io.jmix.flowui.view.EditedEntityContainer;
import io.jmix.flowui.view.Install;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.PrimaryDetailView;
import io.jmix.flowui.view.StandardDetailView;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Target;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import io.openbpm.control.entity.filter.VariableFilter;
import io.openbpm.control.entity.variable.CamundaVariableType;
import io.openbpm.control.entity.variable.VariableInstanceData;
import io.openbpm.control.entity.variable.VariableValueInfo;
import io.openbpm.control.service.variable.VariableService;
import io.openbpm.control.service.variable.VariableUtils;
import io.openbpm.control.view.processvariable.VariableInstanceDataDetail;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;

@Route(value="bpm/variableinstancedata", layout=DefaultMainViewParent.class)
@ViewController(value="bpm_VariableInstanceData.detail")
@ViewDescriptor(value="variable-instance-data-detail.xml")
@EditedEntityContainer(value="variableInstanceDc")
@PrimaryDetailView(value=VariableInstanceData.class)
@DialogMode(width="38em", resizable=true)
public class VariableInstanceDataDetail
extends StandardDetailView<VariableInstanceData> {
    protected static final Logger log = LoggerFactory.getLogger(VariableInstanceDataDetail.class);
    @Autowired
    protected DatatypeRegistry datatypeRegistry;
    @Autowired
    protected Metadata metadata;
    @Autowired
    protected UiComponents uiComponents;
    @Autowired
    protected Actions actions;
    @Autowired
    protected VariableService variableService;
    @Autowired
    private CoreProperties coreProperties;
    @ViewComponent
    protected MessageBundle messageBundle;
    @ViewComponent
    protected JmixComboBox<CamundaVariableType> typeComboBox;
    @ViewComponent
    protected TypedTextField<String> nameField;
    @ViewComponent
    protected InstanceContainer<VariableInstanceData> variableInstanceDc;
    @ViewComponent
    protected JmixFormLayout form;
    @ViewComponent
    protected TypedTextField<String> objectTypeInfoField;
    @ViewComponent
    protected JmixFormLayout valueForm;
    @ViewComponent
    protected TypedTextField<String> serializationDataFormatField;
    @ViewComponent
    protected JmixButton saveBtn;
    @ViewComponent
    protected JmixButton okBtn;
    @ViewComponent
    protected TypedTextField<String> activityInstanceIdField;
    protected Component valueComponent;
    protected String processInstanceId;
    protected VariableInstanceData originalVariableInstanceData;
    protected boolean newVariable = false;
    protected boolean saveEnabled = false;
    protected boolean validationEnabled = false;

    public void setSaveEnabled(boolean saveVisible) {
        this.saveEnabled = saveVisible;
    }

    public void setNewVariable(boolean editable) {
        this.newVariable = editable;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public void setValidationEnabled(boolean validationEnabled) {
        this.validationEnabled = validationEnabled;
    }

    @Subscribe
    public void onInit(View.InitEvent event) {
        this.addClassNames(new String[]{"pt-xs"});
        this.valueForm.getOwnComponents().forEach(component -> component.addClassNames(new String[]{"pt-s"}));
    }

    @Subscribe
    public void onBeforeShow(View.BeforeShowEvent event) {
        this.initTypeLookup();
        this.initActions();
        this.initValueComponent();
        this.initVisibleComponents();
    }

    protected void initVisibleComponents() {
        if (!this.newVariable) {
            this.activityInstanceIdField.setVisible(true);
        }
    }

    @Subscribe(id="variableInstanceDc", target=Target.DATA_CONTAINER)
    public void onVariableInstanceDcItemPropertyChange(InstanceContainer.ItemPropertyChangeEvent<VariableInstanceData> event) {
        if ("type".equals(event.getProperty())) {
            ((VariableInstanceData)event.getItem()).setValue(null);
            this.initValueComponent();
        }
    }

    @Subscribe
    public void onValidation(StandardDetailView.ValidationEvent event) {
        VariableInstanceData variableInstanceData = (VariableInstanceData)this.getEditedEntity();
        if (!this.validationEnabled) {
            return;
        }
        if (this.newVariable || !StringUtils.equals((CharSequence)variableInstanceData.getName(), (CharSequence)this.originalVariableInstanceData.getName())) {
            VariableFilter variableFilter = (VariableFilter)this.metadata.create(VariableFilter.class);
            variableFilter.setProcessInstanceId(this.processInstanceId);
            variableFilter.setVariableName(variableInstanceData.getName());
            long runtimeVariablesCount = this.variableService.getRuntimeVariablesCount(variableFilter);
            if (runtimeVariablesCount > 0L) {
                event.getErrors().add((Component)this.nameField, this.messageBundle.getMessage("variableNameAlreadyExistsError"));
                this.nameField.setInvalid(true);
            }
        }
    }

    @Install(to="variableInstanceDl", target=Target.DATA_LOADER)
    private VariableInstanceData variableInstanceDlLoadDelegate(LoadContext<VariableInstanceData> loadContext) {
        VariableInstanceData variableInstanceData;
        this.originalVariableInstanceData = variableInstanceData = this.variableService.findRuntimeVariableById((String)loadContext.getId());
        return variableInstanceData;
    }

    @Install(target=Target.DATA_CONTEXT)
    private Set<VariableInstanceData> saveDelegate(SaveContext saveContext) {
        VariableInstanceData variableInstanceData = (VariableInstanceData)this.variableInstanceDc.getItem();
        if (this.saveEnabled) {
            String type = variableInstanceData.getType();
            if (CamundaVariableType.FILE.getId().equals(type) || CamundaVariableType.BYTES.getId().equals(type)) {
                this.variableService.updateVariableBinary(variableInstanceData, (File)variableInstanceData.getValue());
            } else {
                this.variableService.updateVariableLocal(variableInstanceData);
            }
        }
        return Set.of((VariableInstanceData)this.getEditedEntity());
    }

    protected void initTypeLookup() {
        this.typeComboBox.setItems(CamundaVariableType.class);
        this.typeComboBox.setItemLabelGenerator(CamundaVariableType::getId);
        this.typeComboBox.setRequired(true);
        this.typeComboBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            ((VariableInstanceData)this.getEditedEntity()).setType(((CamundaVariableType)event.getValue()).getId());
            this.updateComponentsVisibility((CamundaVariableType)event.getValue());
        });
        String type = ((VariableInstanceData)this.getEditedEntity()).getType();
        if (type != null) {
            CamundaVariableType camundaVariableType = CamundaVariableType.fromId((String)type);
            this.typeComboBox.setValue((Object)camundaVariableType);
            this.updateComponentsVisibility(camundaVariableType);
        }
    }

    protected void initValueComponent() {
        this.valueForm.removeAll();
        VariableInstanceData variableInstance = (VariableInstanceData)this.variableInstanceDc.getItem();
        if (variableInstance.getType() != null) {
            this.valueComponent = this.createComponent(variableInstance);
            this.setupValueComponent(this.valueComponent);
        }
    }

    protected void setupValueComponent(Component valueComponent) {
        Object value;
        VariableInstanceData variableInstance = (VariableInstanceData)this.variableInstanceDc.getItem();
        ((HasSize)valueComponent).setWidthFull();
        if (valueComponent instanceof HasValue && (value = variableInstance.getValue()) != null) {
            if (valueComponent instanceof TypedTextField) {
                TypedTextField typedTextField = (TypedTextField)valueComponent;
                typedTextField.setTypedValue(value);
            } else if (valueComponent instanceof TypedDateTimePicker) {
                TypedDateTimePicker typedDateTimePicker = (TypedDateTimePicker)valueComponent;
                typedDateTimePicker.setTypedValue((Comparable)VariableUtils.parseDateValue((Object)value));
            } else {
                ((HasValue)valueComponent).setValue(value);
            }
        }
        this.valueForm.addFormItem(valueComponent, this.messageBundle.getMessage("variableInstanceDataEdit.value"));
    }

    protected void initActions() {
        this.saveBtn.setVisible(this.saveEnabled);
        this.okBtn.setVisible(!this.saveEnabled);
    }

    protected Component createComponent(VariableInstanceData variableInstance) {
        String typeName = variableInstance.getType();
        CamundaVariableType type = CamundaVariableType.fromId((String)typeName);
        if (type == null) {
            return this.createTextField(String.class);
        }
        return switch (1.$SwitchMap$io$openbpm$control$entity$variable$CamundaVariableType[type.ordinal()]) {
            case 1 -> this.createTextField(Long.class);
            case 2 -> this.createTextField(Short.class);
            case 3 -> this.createIntegerField();
            case 4 -> this.createNumberField();
            case 5 -> this.createDateField(Date.class);
            case 6 -> this.createBooleanField();
            case 7, 8 -> this.createFileField();
            case 9 -> this.createObjectField();
            default -> this.createTextField(String.class);
        };
    }

    protected TextArea createObjectField() {
        JmixTextArea textArea = (JmixTextArea)this.uiComponents.create(JmixTextArea.class);
        textArea.setValueChangeMode(ValueChangeMode.ON_BLUR);
        textArea.addClassName("resizable-vertical");
        textArea.setMinHeight("9,5em");
        textArea.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            String value = (String)event.getValue();
            ((VariableInstanceData)this.getEditedEntity()).setValue((Object)value);
        });
        return textArea;
    }

    protected FileUploadField createFileField() {
        VariableInstanceData variableInstanceData = (VariableInstanceData)this.getEditedEntity();
        FileUploadField fileUploadField = (FileUploadField)this.uiComponents.create(FileUploadField.class);
        fileUploadField.setDropAllowed(true);
        fileUploadField.setFileNameVisible(true);
        fileUploadField.setClearButtonVisible(true);
        fileUploadField.setRequired(true);
        VariableValueInfo variableValueInfo = variableInstanceData.getValueInfo();
        if (variableValueInfo != null) {
            fileUploadField.setFileName(variableValueInfo.getFilename());
        }
        fileUploadField.addFileUploadSucceededListener(arg_0 -> this.handleFileUpload(arg_0));
        byte[] binaryValue = this.loadBinaryValue(variableInstanceData);
        fileUploadField.setValue((Object)binaryValue);
        return fileUploadField;
    }

    protected void handleFileUpload(FileUploadSucceededEvent<FileUploadField> event) {
        MemoryBuffer memoryBuffer = (MemoryBuffer)event.getReceiver();
        VariableValueInfo valueInfo = ((VariableInstanceData)this.getEditedEntity()).getValueInfo();
        valueInfo.setFilename(memoryBuffer.getFileName());
        valueInfo.setMimeType(memoryBuffer.getFileData().getMimeType());
        OutputStream outputBuffer = memoryBuffer.getFileData().getOutputBuffer();
        ByteArrayOutputStream fileBytes = (ByteArrayOutputStream)outputBuffer;
        String tempDir = this.coreProperties.getTempDir();
        File dir = new File(tempDir);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new FileStorageException(FileStorageException.Type.IO_EXCEPTION, "Cannot create temp directory: " + dir.getAbsolutePath());
        }
        File outputFile = new File(tempDir, memoryBuffer.getFileName());
        try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
            fileBytes.writeTo(outputStream);
            ((VariableInstanceData)this.getEditedEntity()).setValue((Object)outputFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Error storing uploaded file", e);
        }
    }

    protected byte[] loadBinaryValue(VariableInstanceData variableInstanceData) {
        String type = variableInstanceData.getType();
        if (!this.newVariable && (type.equals(CamundaVariableType.FILE.getId()) || type.equals(CamundaVariableType.BYTES.getId()))) {
            Resource resource = this.variableService.getVariableInstanceBinary(variableInstanceData.getVariableInstanceId());
            try {
                return resource.getContentAsByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException("Error loading binary value", e);
            }
        }
        return null;
    }

    protected Select<Boolean> createBooleanField() {
        JmixSelect jmixSelect = (JmixSelect)this.uiComponents.create(JmixSelect.class);
        jmixSelect.setEmptySelectionAllowed(true);
        jmixSelect.setItems((Object[])new Boolean[]{Boolean.FALSE, Boolean.TRUE});
        jmixSelect.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> ((VariableInstanceData)this.getEditedEntity()).setValue(event.getValue()));
        return jmixSelect;
    }

    protected NumberField createNumberField() {
        NumberField numberField = (NumberField)this.uiComponents.create(NumberField.class);
        numberField.setValueChangeMode(ValueChangeMode.ON_BLUR);
        numberField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> ((VariableInstanceData)this.getEditedEntity()).setValue(event.getValue()));
        return numberField;
    }

    protected IntegerField createIntegerField() {
        IntegerField integerField = (IntegerField)this.uiComponents.create(IntegerField.class);
        integerField.setValueChangeMode(ValueChangeMode.ON_BLUR);
        integerField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> ((VariableInstanceData)this.getEditedEntity()).setValue(event.getValue()));
        return integerField;
    }

    protected <V extends Comparable<?>> TypedDateTimePicker<V> createDateField(Class<V> clazz) {
        TypedDateTimePicker component = (TypedDateTimePicker)this.uiComponents.create(TypedDateTimePicker.class);
        component.setDatatype(this.datatypeRegistry.get(clazz));
        if (((VariableInstanceData)this.getEditedEntity()).getValue() == null) {
            component.setValue(LocalDateTime.now());
        }
        component.addTypedValueChangeListener((ComponentEventListener & Serializable)event -> {
            Comparable value = (Comparable)event.getValue();
            ((VariableInstanceData)this.getEditedEntity()).setValue((Object)value);
        });
        return component;
    }

    protected <V> TypedTextField<V> createTextField(Class<V> clazz) {
        TypedTextField component = (TypedTextField)this.uiComponents.create(TypedTextField.class);
        component.setDatatype(this.datatypeRegistry.get(clazz));
        component.setValueChangeMode(ValueChangeMode.ON_BLUR);
        component.addTypedValueChangeListener((ComponentEventListener & Serializable)event -> {
            Object value = event.getValue();
            ((VariableInstanceData)this.getEditedEntity()).setValue(value);
        });
        return component;
    }

    protected void updateComponentsVisibility(CamundaVariableType camundaVariableType) {
        boolean isObjectType = camundaVariableType == CamundaVariableType.OBJECT;
        this.objectTypeInfoField.setVisible(isObjectType);
        this.serializationDataFormatField.setVisible(isObjectType);
        boolean nullType = camundaVariableType == CamundaVariableType.NULL;
        this.valueForm.setVisible(!nullType);
    }
}

