/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.util;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import io.jmix.core.Messages;
import io.jmix.core.metamodel.datatype.DatatypeFormatter;
import io.jmix.core.security.CurrentAuthentication;
import io.jmix.flowui.UiComponents;
import io.openbpm.control.entity.processinstance.ProcessInstanceState;
import io.openbpm.control.view.util.ComponentHelper;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.TimeZone;
import lombok.Generated;
import org.springframework.lang.Nullable;

@org.springframework.stereotype.Component
public class ComponentHelper {
    protected final UiComponents uiComponents;
    protected final Messages messages;
    protected final DatatypeFormatter datatypeFormatter;
    protected final CurrentAuthentication currentAuthentication;

    public Span createProcessInstanceStateBadge(ProcessInstanceState state) {
        Icon icon;
        String stateTheme = switch (1.$SwitchMap$io$openbpm$control$entity$processinstance$ProcessInstanceState[state.ordinal()]) {
            case 1 -> {
                icon = VaadinIcon.CHECK.create();
                icon.addClassNames(new String[]{"p-xs"});
                yield "contrast";
            }
            case 2 -> {
                icon = VaadinIcon.PAUSE.create();
                icon.addClassNames(new String[]{"suspended-state-small-icon"});
                yield "warning";
            }
            default -> {
                icon = VaadinIcon.HOURGLASS.create();
                icon.addClassNames(new String[]{"p-xs"});
                yield "success";
            }
        };
        Span span = (Span)this.uiComponents.create(Span.class);
        span.getElement().getThemeList().add((Object)("badge pill " + stateTheme));
        Span text = (Span)this.uiComponents.create(Span.class);
        text.setText(this.messages.getMessage((Enum)state));
        span.add(new Component[]{icon, text});
        return span;
    }

    public Span createDateSpan(@Nullable OffsetDateTime date) {
        Span span = (Span)this.uiComponents.create(Span.class);
        TimeZone timeZone = this.currentAuthentication.getTimeZone();
        if (date != null) {
            LocalDateTime timestamp = date.atZoneSameInstant(timeZone.toZoneId()).toLocalDateTime();
            String formattedDate = this.datatypeFormatter.formatLocalDateTime(timestamp);
            span.setText(formattedDate);
        }
        return span;
    }

    @Generated
    public ComponentHelper(UiComponents uiComponents, Messages messages, DatatypeFormatter datatypeFormatter, CurrentAuthentication currentAuthentication) {
        this.uiComponents = uiComponents;
        this.messages = messages;
        this.datatypeFormatter = datatypeFormatter;
        this.currentAuthentication = currentAuthentication;
    }
}

