/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.spring.boot.starter.security.oauth2.impl;

import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class ClientsNotConfiguredCondition
extends SpringBootCondition {
    private static final String OAUTH2_CLIENT_REGISTRATION_PROPERTY_PREFIX = "spring.security.oauth2.client.registration";

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        return this.hasClientRegistrations(context) ? new ConditionOutcome(false, "OAuth2 client is configured") : new ConditionOutcome(true, "No OAuth2 client is configured");
    }

    private boolean hasClientRegistrations(ConditionContext context) {
        Binder binder = Binder.get((Environment)context.getEnvironment());
        return (Boolean)binder.bind(OAUTH2_CLIENT_REGISTRATION_PROPERTY_PREFIX, Map.class).map(map -> !map.isEmpty()).orElse((Object)false);
    }
}

