/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.spring.boot.starter.security.oauth2.impl;

import io.openbpm.bpm.spring.boot.starter.security.oauth2.OAuth2Properties;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.oidc.web.logout.OidcClientInitiatedLogoutSuccessHandler;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;

public class SsoLogoutSuccessHandler
extends OidcClientInitiatedLogoutSuccessHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SsoLogoutSuccessHandler.class);

    public SsoLogoutSuccessHandler(ClientRegistrationRepository clientRegistrationRepository, OAuth2Properties oAuth2Properties) {
        super(clientRegistrationRepository);
        this.setPostLogoutRedirectUri(oAuth2Properties.getSsoLogout().getPostLogoutRedirectUri());
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        LOGGER.debug("Initiating SSO logout for '{}'", (Object)authentication.getName());
        super.onLogoutSuccess(request, response, authentication);
    }
}

