/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.admin.impl;

import io.openbpm.bpm.admin.AdminRuntimeDelegate;
import io.openbpm.bpm.admin.plugin.spi.AdminPlugin;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.impl.ProcessEngineImpl;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.webapp.db.CommandExecutor;
import io.openbpm.bpm.webapp.db.QueryService;
import io.openbpm.bpm.webapp.impl.AbstractAppRuntimeDelegate;
import io.openbpm.bpm.webapp.impl.db.CommandExecutorImpl;
import io.openbpm.bpm.webapp.impl.db.QueryServiceImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultAdminRuntimeDelegate
extends AbstractAppRuntimeDelegate<AdminPlugin>
implements AdminRuntimeDelegate {
    private static final List<String> MAPPING_FILES = List.of("io/openbpm/bpm/admin/plugin/base/queries/metrics.xml");
    protected final Map<String, CommandExecutor> commandExecutors = new HashMap<String, CommandExecutor>();

    public DefaultAdminRuntimeDelegate() {
        super(AdminPlugin.class);
    }

    @Override
    public QueryService getQueryService(String processEngineName) {
        CommandExecutor commandExecutor = this.getCommandExecutor(processEngineName);
        return new QueryServiceImpl(commandExecutor);
    }

    public CommandExecutor getCommandExecutor(String processEngineName) {
        return this.commandExecutors.computeIfAbsent(processEngineName, this::createCommandExecutor);
    }

    protected CommandExecutor createCommandExecutor(String processEngineName) {
        ProcessEngine processEngine = this.getProcessEngine(processEngineName);
        if (processEngine == null) {
            throw new ProcessEngineException("No process engine with name " + processEngineName + " found.");
        }
        ProcessEngineConfigurationImpl processEngineConfiguration = ((ProcessEngineImpl)processEngine).getProcessEngineConfiguration();
        return new CommandExecutorImpl(processEngineConfiguration, MAPPING_FILES);
    }
}

