/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.admin.impl.plugin.resources;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.admin.impl.plugin.base.dto.MetricsAggregatedQueryDto;
import io.openbpm.bpm.admin.impl.plugin.base.dto.MetricsAggregatedResultDto;
import io.openbpm.bpm.admin.resource.AbstractAdminPluginResource;
import io.openbpm.bpm.engine.impl.metrics.util.MetricsUtil;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.List;

public class MetricsRestService
extends AbstractAdminPluginResource {
    public static final String PATH = "/metrics";
    public static final ObjectMapper objectMapper = new ObjectMapper();

    public MetricsRestService(String engineName) {
        super(engineName);
    }

    @GET
    @Path(value="/aggregated")
    @Produces(value={"application/json"})
    public List<MetricsAggregatedResultDto> getAggregatedMetrics(@Context UriInfo uriInfo) {
        MetricsAggregatedQueryDto queryDto = new MetricsAggregatedQueryDto(objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        queryDto.validateAndPrepareQuery();
        boolean queryTaskUsers = queryDto.getMetrics().remove("unique-task-workers");
        ArrayList<MetricsAggregatedResultDto> result = new ArrayList<MetricsAggregatedResultDto>();
        if (!queryDto.getMetrics().isEmpty()) {
            result.addAll(this.getQueryService().executeQuery("selectMetricsAggregated", queryDto));
        }
        if (queryTaskUsers) {
            result.addAll(this.getQueryService().executeQuery("selectMetricsAggregatedTU", queryDto));
        }
        result.forEach(resultDto -> resultDto.setMetric(MetricsUtil.resolvePublicName((String)resultDto.getMetric())));
        return result;
    }
}

