/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.cockpit.impl;

import io.openbpm.bpm.cockpit.CockpitRuntimeDelegate;
import io.openbpm.bpm.cockpit.db.CommandExecutor;
import io.openbpm.bpm.cockpit.db.QueryService;
import io.openbpm.bpm.cockpit.impl.db.CommandExecutorImpl;
import io.openbpm.bpm.cockpit.impl.db.QueryServiceImpl;
import io.openbpm.bpm.cockpit.impl.plugin.DefaultPluginRegistry;
import io.openbpm.bpm.cockpit.plugin.PluginRegistry;
import io.openbpm.bpm.cockpit.plugin.spi.CockpitPlugin;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.impl.ProcessEngineImpl;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.webapp.impl.AbstractAppRuntimeDelegate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultCockpitRuntimeDelegate
extends AbstractAppRuntimeDelegate<CockpitPlugin>
implements CockpitRuntimeDelegate {
    private final Map<String, CommandExecutor> commandExecutors = new HashMap<String, CommandExecutor>();

    public DefaultCockpitRuntimeDelegate() {
        super(CockpitPlugin.class);
    }

    @Override
    public QueryService getQueryService(String processEngineName) {
        CommandExecutor commandExecutor = this.getCommandExecutor(processEngineName);
        return new QueryServiceImpl(commandExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandExecutor getCommandExecutor(String processEngineName) {
        Map<String, CommandExecutor> map = this.commandExecutors;
        synchronized (map) {
            return this.commandExecutors.computeIfAbsent(processEngineName, this::createCommandExecutor);
        }
    }

    @Override
    @Deprecated(forRemoval=true, since="1.0")
    public PluginRegistry getPluginRegistry() {
        return new DefaultPluginRegistry(this.pluginRegistry);
    }

    protected List<String> getMappingFiles() {
        List cockpitPlugins = this.pluginRegistry.getPlugins();
        ArrayList<String> mappingFiles = new ArrayList<String>();
        for (CockpitPlugin plugin : cockpitPlugins) {
            mappingFiles.addAll(plugin.getMappingFiles());
        }
        return mappingFiles;
    }

    protected CommandExecutor createCommandExecutor(String processEngineName) {
        ProcessEngine processEngine = this.getProcessEngine(processEngineName);
        if (processEngine == null) {
            throw new ProcessEngineException("No process engine with name " + processEngineName + " found.");
        }
        ProcessEngineConfigurationImpl processEngineConfiguration = ((ProcessEngineImpl)processEngine).getProcessEngineConfiguration();
        List<String> mappingFiles = this.getMappingFiles();
        return new CommandExecutorImpl(processEngineConfiguration, mappingFiles);
    }
}

