/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.cockpit.impl.plugin.base.dto.query;

import io.openbpm.bpm.cockpit.impl.plugin.base.dto.IncidentDto;
import io.openbpm.bpm.cockpit.rest.dto.AbstractRestQueryParametersDto;
import io.openbpm.bpm.engine.rest.dto.OperatonQueryParam;
import io.openbpm.bpm.engine.rest.dto.converter.StringArrayConverter;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IncidentQueryDto
extends AbstractRestQueryParametersDto<IncidentDto> {
    private static final long serialVersionUID = 1L;
    private static final String SORT_BY_INCIDENT_TIMESTAMP = "incidentTimestamp";
    private static final String SORT_BY_INCIDENT_MESSAGE = "incidentMessage";
    private static final String SORT_BY_INCIDENT_TYPE = "incidentType";
    private static final String SORT_BY_ACTIVITY_ID = "activityId";
    private static final String SORT_BY_CAUSE_INCIDENT_PROCESS_INSTANCE_ID = "causeIncidentProcessInstanceId";
    private static final String SORT_BY_ROOT_CAUSE_INCIDENT_PROCESS_INSTANCE_ID = "rootCauseIncidentProcessInstanceId";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    private static final Map<String, String> ORDER_BY_VALUES;
    protected String[] processDefinitionIdIn;
    protected String[] processInstanceIdIn;
    protected String[] activityIdIn;

    public IncidentQueryDto() {
    }

    public IncidentQueryDto(MultivaluedMap<String, String> queryParameters) {
        super(queryParameters);
    }

    public String[] getProcessDefinitionIdIn() {
        return this.processDefinitionIdIn;
    }

    @OperatonQueryParam(value="processDefinitionIdIn", converter=StringArrayConverter.class)
    public void setProcessDefinitionIdIn(String[] processDefinitionIdIn) {
        this.processDefinitionIdIn = processDefinitionIdIn;
    }

    public String[] getProcessInstanceIdIn() {
        return this.processInstanceIdIn;
    }

    @OperatonQueryParam(value="processInstanceIdIn", converter=StringArrayConverter.class)
    public void setProcessInstanceIdIn(String[] processInstanceIdIn) {
        this.processInstanceIdIn = processInstanceIdIn;
    }

    public String[] getActivityIdIn() {
        return this.activityIdIn;
    }

    @OperatonQueryParam(value="activityIdIn", converter=StringArrayConverter.class)
    public void setActivityIdIn(String[] activityIdIn) {
        this.activityIdIn = activityIdIn;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected String getOrderByValue(String sortBy) {
        return ORDER_BY_VALUES.get(sortBy);
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_INCIDENT_TIMESTAMP);
        VALID_SORT_BY_VALUES.add(SORT_BY_INCIDENT_MESSAGE);
        VALID_SORT_BY_VALUES.add(SORT_BY_INCIDENT_TYPE);
        VALID_SORT_BY_VALUES.add(SORT_BY_ACTIVITY_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_CAUSE_INCIDENT_PROCESS_INSTANCE_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_ROOT_CAUSE_INCIDENT_PROCESS_INSTANCE_ID);
        ORDER_BY_VALUES = new HashMap<String, String>();
        ORDER_BY_VALUES.put(SORT_BY_INCIDENT_MESSAGE, "RES.INCIDENT_MSG_");
        ORDER_BY_VALUES.put(SORT_BY_INCIDENT_TIMESTAMP, "RES.INCIDENT_TIMESTAMP_");
        ORDER_BY_VALUES.put(SORT_BY_INCIDENT_TYPE, "RES.INCIDENT_TYPE_");
        ORDER_BY_VALUES.put(SORT_BY_ACTIVITY_ID, "RES.ACTIVITY_ID_");
        ORDER_BY_VALUES.put(SORT_BY_CAUSE_INCIDENT_PROCESS_INSTANCE_ID, "RES.CAUSE_PROC_INST_ID_");
        ORDER_BY_VALUES.put(SORT_BY_ROOT_CAUSE_INCIDENT_PROCESS_INSTANCE_ID, "RES.ROOT_PROC_INST_ID_");
    }
}

