/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.cockpit.impl.plugin.base.sub.resources;

import io.openbpm.bpm.cockpit.impl.plugin.base.dto.ProcessDefinitionDto;
import io.openbpm.bpm.cockpit.impl.plugin.base.dto.query.ProcessDefinitionQueryDto;
import io.openbpm.bpm.cockpit.plugin.resource.AbstractPluginResource;
import io.openbpm.bpm.engine.authorization.Permission;
import io.openbpm.bpm.engine.authorization.Permissions;
import io.openbpm.bpm.engine.authorization.Resource;
import io.openbpm.bpm.engine.authorization.Resources;
import io.openbpm.bpm.engine.impl.ProcessEngineImpl;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.history.HistoryLevel;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;

public class ProcessDefinitionResource
extends AbstractPluginResource {
    protected String id;

    public ProcessDefinitionResource(String engineName, String id) {
        super(engineName);
        this.id = id;
    }

    @GET
    @Path(value="/called-process-definitions")
    @Produces(value={"application/json"})
    public List<ProcessDefinitionDto> getCalledProcessDefinitions(@Context UriInfo uriInfo) {
        ProcessDefinitionQueryDto queryParameter = new ProcessDefinitionQueryDto((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryCalledProcessDefinitions(queryParameter);
    }

    @POST
    @Path(value="/called-process-definitions")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public List<ProcessDefinitionDto> queryCalledProcessDefinitions(ProcessDefinitionQueryDto queryParameter) {
        return this.getCommandExecutor().executeCommand(new QueryCalledProcessDefinitionsCmd(queryParameter));
    }

    protected void configureExecutionQuery(ProcessDefinitionQueryDto query) {
        this.configureAuthorizationCheck(query);
        this.configureTenantCheck(query);
        this.addPermissionCheck(query, (Resource)Resources.PROCESS_INSTANCE, "EXEC2.PROC_INST_ID_", (Permission)Permissions.READ);
        this.addPermissionCheck(query, (Resource)Resources.PROCESS_DEFINITION, "PROCDEF.KEY_", (Permission)Permissions.READ_INSTANCE);
    }

    protected class QueryCalledProcessDefinitionsCmd
    implements Command<List<ProcessDefinitionDto>> {
        protected ProcessDefinitionQueryDto queryParameter;

        public QueryCalledProcessDefinitionsCmd(ProcessDefinitionQueryDto queryParameter) {
            this.queryParameter = queryParameter;
        }

        public List<ProcessDefinitionDto> execute(CommandContext commandContext) {
            this.queryParameter.setParentProcessDefinitionId(ProcessDefinitionResource.this.id);
            this.injectEngineConfig(this.queryParameter);
            ProcessDefinitionResource.this.configureExecutionQuery(this.queryParameter);
            this.queryParameter.disableMaxResultsLimit();
            return ProcessDefinitionResource.this.getQueryService().executeQuery("selectCalledProcessDefinitions", this.queryParameter);
        }

        private void injectEngineConfig(ProcessDefinitionQueryDto parameter) {
            ProcessEngineConfigurationImpl processEngineConfiguration = ((ProcessEngineImpl)ProcessDefinitionResource.this.getProcessEngine()).getProcessEngineConfiguration();
            if (processEngineConfiguration.getHistoryLevel().equals(HistoryLevel.HISTORY_LEVEL_NONE)) {
                parameter.setHistoryEnabled(false);
            }
            parameter.initQueryVariableValues(processEngineConfiguration.getVariableSerializers(), processEngineConfiguration.getDatabaseType());
        }
    }
}

