/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.cockpit.impl.plugin.resources;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.cockpit.impl.plugin.base.dto.ProcessInstanceDto;
import io.openbpm.bpm.cockpit.impl.plugin.base.dto.query.ProcessInstanceQueryDto;
import io.openbpm.bpm.cockpit.impl.plugin.base.sub.resources.ProcessInstanceResource;
import io.openbpm.bpm.cockpit.plugin.resource.AbstractPluginResource;
import io.openbpm.bpm.engine.authorization.Permission;
import io.openbpm.bpm.engine.authorization.Permissions;
import io.openbpm.bpm.engine.authorization.Resource;
import io.openbpm.bpm.engine.authorization.Resources;
import io.openbpm.bpm.engine.impl.ProcessEngineImpl;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.history.HistoryLevel;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.rest.dto.CountResultDto;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;

public class ProcessInstanceRestService
extends AbstractPluginResource {
    public static final String PATH = "/process-instance";
    protected ObjectMapper objectMapper;

    public ProcessInstanceRestService(String engineName) {
        super(engineName);
    }

    @Path(value="/{id}")
    public ProcessInstanceResource getProcessInstance(@PathParam(value="id") String id) {
        return new ProcessInstanceResource(this.getProcessEngine().getName(), id);
    }

    @GET
    @Produces(value={"application/json"})
    public List<ProcessInstanceDto> getProcessInstances(@Context UriInfo uriInfo, @QueryParam(value="firstResult") Integer firstResult, @QueryParam(value="maxResults") Integer maxResults) {
        ProcessInstanceQueryDto queryParameter = new ProcessInstanceQueryDto((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryProcessInstances(queryParameter, firstResult, maxResults);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public List<ProcessInstanceDto> queryProcessInstances(ProcessInstanceQueryDto queryParameter, @QueryParam(value="firstResult") Integer firstResult, @QueryParam(value="maxResults") Integer maxResults) {
        return this.getCommandExecutor().executeCommand(new QueryProcessInstancesCmd(queryParameter, firstResult, maxResults));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/count")
    public CountResultDto getProcessInstancesCount(@Context UriInfo uriInfo) {
        ProcessInstanceQueryDto queryParameter = new ProcessInstanceQueryDto((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryProcessInstancesCount(queryParameter);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/count")
    public CountResultDto queryProcessInstancesCount(ProcessInstanceQueryDto queryParameter) {
        return this.getCommandExecutor().executeCommand(new QueryProcessInstancesCountCmd(queryParameter));
    }

    private void injectEngineConfig(ProcessInstanceQueryDto parameter) {
        ProcessEngineConfigurationImpl processEngineConfiguration = ((ProcessEngineImpl)this.getProcessEngine()).getProcessEngineConfiguration();
        if (processEngineConfiguration.getHistoryLevel().equals(HistoryLevel.HISTORY_LEVEL_NONE)) {
            parameter.setHistoryEnabled(false);
        }
        parameter.initQueryVariableValues(processEngineConfiguration.getVariableSerializers(), processEngineConfiguration.getDatabaseType());
    }

    protected void configureExecutionQuery(ProcessInstanceQueryDto query) {
        this.configureAuthorizationCheck(query);
        this.configureTenantCheck(query);
        this.addPermissionCheck(query, (Resource)Resources.PROCESS_INSTANCE, "RES.PROC_INST_ID_", (Permission)Permissions.READ);
        this.addPermissionCheck(query, (Resource)Resources.PROCESS_DEFINITION, "P.KEY_", (Permission)Permissions.READ_INSTANCE);
    }

    protected void injectObjectMapper(ProcessInstanceQueryDto queryParameter) {
        queryParameter.setObjectMapper(this.objectMapper);
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    protected class QueryProcessInstancesCmd
    implements Command<List<ProcessInstanceDto>> {
        protected ProcessInstanceQueryDto queryParameter;
        protected Integer firstResult;
        protected Integer maxResults;

        public QueryProcessInstancesCmd(ProcessInstanceQueryDto queryParameter, Integer firstResult, Integer maxResults) {
            this.queryParameter = queryParameter;
            this.firstResult = firstResult;
            this.maxResults = maxResults;
        }

        public List<ProcessInstanceDto> execute(CommandContext commandContext) {
            ProcessInstanceRestService.this.injectObjectMapper(this.queryParameter);
            ProcessInstanceRestService.this.injectEngineConfig(this.queryParameter);
            this.paginate(this.queryParameter, this.firstResult, this.maxResults);
            ProcessInstanceRestService.this.configureExecutionQuery(this.queryParameter);
            return ProcessInstanceRestService.this.getQueryService().executeQuery("selectRunningProcessInstancesIncludingIncidents", this.queryParameter);
        }

        private void paginate(ProcessInstanceQueryDto queryParameter, Integer firstResult, Integer maxResults) {
            if (firstResult == null) {
                firstResult = 0;
            }
            if (maxResults == null) {
                maxResults = Integer.MAX_VALUE;
            }
            queryParameter.setFirstResult(firstResult);
            queryParameter.setMaxResults(maxResults);
        }
    }

    protected class QueryProcessInstancesCountCmd
    implements Command<CountResultDto> {
        protected ProcessInstanceQueryDto queryParameter;

        public QueryProcessInstancesCountCmd(ProcessInstanceQueryDto queryParameter) {
            this.queryParameter = queryParameter;
        }

        public CountResultDto execute(CommandContext commandContext) {
            ProcessInstanceRestService.this.injectEngineConfig(this.queryParameter);
            ProcessInstanceRestService.this.configureExecutionQuery(this.queryParameter);
            long result = ProcessInstanceRestService.this.getQueryService().executeQueryRowCount("selectRunningProcessInstancesCount", this.queryParameter);
            return new CountResultDto(result);
        }
    }
}

