/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.webapp.impl.security.auth;

import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.rest.security.auth.AuthenticationProvider;
import io.openbpm.bpm.engine.rest.security.auth.AuthenticationResult;
import io.openbpm.bpm.webapp.impl.security.auth.Authentication;
import io.openbpm.bpm.webapp.impl.security.auth.AuthenticationUtil;
import io.openbpm.bpm.webapp.impl.security.auth.Authentications;
import io.openbpm.bpm.webapp.impl.security.auth.UserAuthentication;
import io.openbpm.bpm.webapp.impl.util.ProcessEngineUtil;
import io.openbpm.bpm.webapp.impl.util.ServletContextUtil;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContainerBasedAuthenticationFilter
implements Filter {
    public static final Pattern APP_PATTERN = Pattern.compile("/app/(cockpit|admin|tasklist|welcome)/([^/]+)/");
    public static final Pattern API_ENGINE_PATTERN = Pattern.compile("/api/engine/engine/([^/]+)/.*");
    public static final Pattern API_STATIC_PLUGIN_PATTERN = Pattern.compile("/api/(cockpit|admin|tasklist|welcome)/plugin/[^/]+/static/.*");
    public static final Pattern API_PLUGIN_PATTERN = Pattern.compile("/api/(cockpit|admin|tasklist|welcome)/plugin/[^/]+/([^/]+)/.*");
    protected AuthenticationProvider authenticationProvider;

    public void init(FilterConfig filterConfig) throws ServletException {
        String authenticationProviderClassName = filterConfig.getInitParameter("authentication-provider");
        if (authenticationProviderClassName == null) {
            throw new ServletException("Cannot instantiate authentication filter: no authentication provider set. init-param authentication-provider missing");
        }
        try {
            Class<?> authenticationProviderClass = Class.forName(authenticationProviderClassName);
            this.authenticationProvider = (AuthenticationProvider)authenticationProviderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new ServletException("Cannot instantiate authentication filter: authentication provider not found", (Throwable)e);
        }
        catch (InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ServletException("Cannot instantiate authentication filter: cannot instantiate authentication provider", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServletException("Cannot instantiate authentication filter: constructor not accessible", (Throwable)e);
        }
        catch (ClassCastException e) {
            throw new ServletException("Cannot instantiate authentication filter: authentication provider does not implement interface " + AuthenticationProvider.class.getName(), (Throwable)e);
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String engineName = this.extractEngineName(req);
        if (engineName == null) {
            chain.doFilter(request, response);
            return;
        }
        ProcessEngine engine = this.getAddressedEngine(engineName);
        if (engine == null) {
            resp.sendError(404, "Process engine " + engineName + " not available");
            return;
        }
        AuthenticationResult authenticationResult = this.authenticationProvider.extractAuthenticatedUser(req, engine);
        if (authenticationResult.isAuthenticated()) {
            String authenticatedUser;
            Authentications authentications = AuthenticationUtil.getAuthsFromSession(req.getSession());
            if (!this.existisAuthentication(authentications, engineName, authenticatedUser = authenticationResult.getAuthenticatedUser())) {
                List groups = authenticationResult.getGroups();
                List tenants = authenticationResult.getTenants();
                UserAuthentication authentication = this.createAuthentication(engine, authenticatedUser, groups, tenants);
                authentications.addOrReplace(authentication);
            }
            chain.doFilter(request, response);
        } else {
            resp.setStatus(Response.Status.UNAUTHORIZED.getStatusCode());
            this.authenticationProvider.augmentResponseByAuthenticationChallenge(resp, engine);
        }
    }

    protected String getRequestUri(HttpServletRequest request) {
        ServletContext servletContext;
        String applicationPath;
        int applicationPathLength;
        String requestURI = request.getRequestURI();
        String contextPath = request.getContextPath();
        int contextPathLength = contextPath.length();
        if (contextPathLength > 0) {
            requestURI = requestURI.substring(contextPathLength);
        }
        if ((applicationPathLength = (applicationPath = ServletContextUtil.getAppPath(servletContext = request.getServletContext())).length()) > 0) {
            requestURI = requestURI.substring(applicationPathLength);
        }
        return requestURI;
    }

    protected String extractEngineName(HttpServletRequest request) {
        String requestUri = this.getRequestUri(request);
        String requestMethod = request.getMethod();
        Matcher appMatcher = APP_PATTERN.matcher(requestUri);
        if (appMatcher.matches()) {
            return appMatcher.group(2);
        }
        Matcher apiEngineMatcher = API_ENGINE_PATTERN.matcher(requestUri);
        if (apiEngineMatcher.matches()) {
            return apiEngineMatcher.group(1);
        }
        Matcher apiStaticPluginPattern = API_STATIC_PLUGIN_PATTERN.matcher(requestUri);
        if ("GET".equals(requestMethod) && apiStaticPluginPattern.matches()) {
            return null;
        }
        Matcher apiPluginPattern = API_PLUGIN_PATTERN.matcher(requestUri);
        if (apiPluginPattern.matches()) {
            return apiPluginPattern.group(2);
        }
        return null;
    }

    protected ProcessEngine getAddressedEngine(String engineName) {
        return ProcessEngineUtil.lookupProcessEngine(engineName);
    }

    protected boolean existisAuthentication(Authentications authentications, String engineName, String username) {
        Authentication authentication = authentications.getAuthenticationForProcessEngine(engineName);
        return authentication != null && this.isAuthenticated(authentication, engineName, username);
    }

    protected boolean isAuthenticated(Authentication authentication, String engineName, String username) {
        String processEngineName = authentication.getProcessEngineName();
        String identityId = authentication.getIdentityId();
        return processEngineName.equals(engineName) && identityId.equals(username);
    }

    protected UserAuthentication createAuthentication(ProcessEngine processEngine, String username, List<String> groups, List<String> tenants) {
        return AuthenticationUtil.createAuthentication(processEngine, username, groups, tenants);
    }
}

