/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.webapp.impl.security.filter;

import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.impl.util.StringUtil;
import io.openbpm.bpm.webapp.impl.security.filter.util.CookieConstants;
import jakarta.servlet.FilterConfig;
import java.util.Arrays;

public class CookieConfigurator {
    protected static final String ENABLE_SECURE_PARAM = "enableSecureCookie";
    protected static final String ENABLE_SAME_SITE_PARAM = "enableSameSiteCookie";
    protected static final String SAME_SITE_OPTION_PARAM = "sameSiteCookieOption";
    protected static final String SAME_SITE_VALUE_PARAM = "sameSiteCookieValue";
    protected boolean isSecureCookieEnabled;
    protected boolean isSameSiteCookieEnabled;
    protected String sameSiteCookieValue;
    protected String cookieName;

    public void parseParams(FilterConfig filterConfig) {
        String enableSameSiteCookieInitParam;
        String sessionCookieName;
        String enableSecureCookieInitParam = filterConfig.getInitParameter(ENABLE_SECURE_PARAM);
        if (StringUtil.hasText((String)enableSecureCookieInitParam)) {
            this.isSecureCookieEnabled = Boolean.parseBoolean(enableSecureCookieInitParam);
        }
        if (StringUtil.hasText((String)(sessionCookieName = filterConfig.getServletContext().getSessionCookieConfig().getName())) && !"JSESSIONID".equals(sessionCookieName)) {
            this.cookieName = sessionCookieName;
        }
        this.isSameSiteCookieEnabled = StringUtil.hasText((String)(enableSameSiteCookieInitParam = filterConfig.getInitParameter(ENABLE_SAME_SITE_PARAM))) ? Boolean.parseBoolean(enableSameSiteCookieInitParam) : true;
        String sameSiteCookieValueInitParam = filterConfig.getInitParameter(SAME_SITE_VALUE_PARAM);
        String sameSiteCookieOptionInitParam = filterConfig.getInitParameter(SAME_SITE_OPTION_PARAM);
        this.sameSiteCookieValue = CookieConfigurator.getSameSiteCookieValueInitValue(sameSiteCookieValueInitParam, sameSiteCookieOptionInitParam);
    }

    public String getConfig() {
        return this.getConfig(null);
    }

    public String getConfig(String currentHeader) {
        StringBuilder stringBuilder = new StringBuilder(currentHeader == null ? "" : currentHeader);
        if (this.isSameSiteCookieEnabled && (currentHeader == null || !CookieConstants.SAME_SITE_FIELD_NAME_REGEX.matcher(currentHeader).find())) {
            stringBuilder.append(";SameSite=").append(this.sameSiteCookieValue);
        }
        if (this.isSecureCookieEnabled && (currentHeader == null || !CookieConstants.SECURE_FLAG_NAME_REGEX.matcher(currentHeader).find())) {
            stringBuilder.append(";Secure");
        }
        return stringBuilder.toString();
    }

    public String getCookieName(String defaultName) {
        return StringUtil.hasText((String)this.cookieName) ? this.cookieName : defaultName;
    }

    static String getSameSiteCookieValueInitValue(String sameSiteCookieValueInitParam, String sameSiteCookieOptionInitParam) {
        if (StringUtil.hasText((String)sameSiteCookieValueInitParam) && StringUtil.hasText((String)sameSiteCookieOptionInitParam)) {
            throw new ProcessEngineException("Please either configure sameSiteCookieOption or sameSiteCookieValue.");
        }
        if (StringUtil.hasText((String)sameSiteCookieValueInitParam)) {
            return sameSiteCookieValueInitParam;
        }
        if (StringUtil.hasText((String)sameSiteCookieOptionInitParam)) {
            if (sameSiteCookieOptionInitParam.equalsIgnoreCase(SameSiteOption.LAX.name())) {
                return SameSiteOption.LAX.getValue();
            }
            if (sameSiteCookieOptionInitParam.equalsIgnoreCase(SameSiteOption.STRICT.name())) {
                return SameSiteOption.STRICT.getValue();
            }
            throw new ProcessEngineException("For sameSiteCookieOption param, please configure one of the following options: " + Arrays.toString(Arrays.stream(SameSiteOption.values()).map(SameSiteOption::getValue).toArray(String[]::new)));
        }
        return SameSiteOption.LAX.getValue();
    }

    public static enum SameSiteOption {
        LAX("Lax"),
        STRICT("Strict");

        private final String value;

        private SameSiteOption(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

