/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.webapp.impl.security.filter;

import io.openbpm.bpm.webapp.impl.security.auth.Authentication;
import io.openbpm.bpm.webapp.impl.security.filter.Authorization;
import io.openbpm.bpm.webapp.impl.security.filter.RequestMatcher;
import io.openbpm.bpm.webapp.impl.security.filter.SecurityFilterRule;
import java.util.ArrayList;
import java.util.List;

public class PathFilterRule
implements SecurityFilterRule {
    protected List<RequestMatcher> allowedPaths = new ArrayList<RequestMatcher>();
    protected List<RequestMatcher> deniedPaths = new ArrayList<RequestMatcher>();

    @Override
    public Authorization authorize(String requestMethod, String requestUri) {
        RequestMatcher.Match match;
        boolean secured = false;
        for (RequestMatcher pattern : this.deniedPaths) {
            match = pattern.match(requestMethod, requestUri);
            if (match == null) continue;
            secured = true;
            break;
        }
        if (!secured) {
            return Authorization.granted(Authentication.ANONYMOUS);
        }
        for (RequestMatcher pattern : this.allowedPaths) {
            match = pattern.match(requestMethod, requestUri);
            if (match == null) continue;
            return match.authorize();
        }
        return null;
    }

    public List<RequestMatcher> getAllowedPaths() {
        return this.allowedPaths;
    }

    public List<RequestMatcher> getDeniedPaths() {
        return this.deniedPaths;
    }
}

