/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.webapp.impl.util;

import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.rest.exception.RestException;
import io.openbpm.bpm.engine.rest.spi.ProcessEngineProvider;
import jakarta.ws.rs.core.Response;
import java.util.Iterator;
import java.util.ServiceLoader;

public final class ProcessEngineUtil {
    public static ProcessEngine lookupProcessEngine(String engineName) {
        ServiceLoader<ProcessEngineProvider> serviceLoader = ServiceLoader.load(ProcessEngineProvider.class);
        Iterator<ProcessEngineProvider> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            ProcessEngineProvider provider = iterator.next();
            return provider.getProcessEngine(engineName);
        }
        throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, "Could not find an implementation of the " + String.valueOf(ProcessEngineProvider.class) + "- SPI");
    }

    private ProcessEngineUtil() {
    }
}

