/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client;

import java.time.Clock;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.security.oauth2.client.AuthorizationCodeReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.ClientCredentialsReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.DelegatingReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.PasswordReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.RefreshTokenReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.endpoint.OAuth2ClientCredentialsGrantRequest;
import org.springframework.security.oauth2.client.endpoint.OAuth2PasswordGrantRequest;
import org.springframework.security.oauth2.client.endpoint.OAuth2RefreshTokenGrantRequest;
import org.springframework.security.oauth2.client.endpoint.ReactiveOAuth2AccessTokenResponseClient;
import org.springframework.util.Assert;

public final class ReactiveOAuth2AuthorizedClientProviderBuilder {
    private final Map<Class<?>, Builder> builders = new LinkedHashMap();

    private ReactiveOAuth2AuthorizedClientProviderBuilder() {
    }

    public static ReactiveOAuth2AuthorizedClientProviderBuilder builder() {
        return new ReactiveOAuth2AuthorizedClientProviderBuilder();
    }

    public ReactiveOAuth2AuthorizedClientProviderBuilder provider(ReactiveOAuth2AuthorizedClientProvider provider) {
        Assert.notNull((Object)provider, (String)"provider cannot be null");
        this.builders.computeIfAbsent(provider.getClass(), k -> () -> provider);
        return this;
    }

    public ReactiveOAuth2AuthorizedClientProviderBuilder authorizationCode() {
        this.builders.computeIfAbsent(AuthorizationCodeReactiveOAuth2AuthorizedClientProvider.class, k -> new AuthorizationCodeGrantBuilder());
        return this;
    }

    public ReactiveOAuth2AuthorizedClientProviderBuilder refreshToken() {
        this.builders.computeIfAbsent(RefreshTokenReactiveOAuth2AuthorizedClientProvider.class, k -> new RefreshTokenGrantBuilder());
        return this;
    }

    public ReactiveOAuth2AuthorizedClientProviderBuilder refreshToken(Consumer<RefreshTokenGrantBuilder> builderConsumer) {
        RefreshTokenGrantBuilder builder = (RefreshTokenGrantBuilder)this.builders.computeIfAbsent(RefreshTokenReactiveOAuth2AuthorizedClientProvider.class, k -> new RefreshTokenGrantBuilder());
        builderConsumer.accept(builder);
        return this;
    }

    public ReactiveOAuth2AuthorizedClientProviderBuilder clientCredentials() {
        this.builders.computeIfAbsent(ClientCredentialsReactiveOAuth2AuthorizedClientProvider.class, k -> new ClientCredentialsGrantBuilder());
        return this;
    }

    public ReactiveOAuth2AuthorizedClientProviderBuilder clientCredentials(Consumer<ClientCredentialsGrantBuilder> builderConsumer) {
        ClientCredentialsGrantBuilder builder = (ClientCredentialsGrantBuilder)this.builders.computeIfAbsent(ClientCredentialsReactiveOAuth2AuthorizedClientProvider.class, k -> new ClientCredentialsGrantBuilder());
        builderConsumer.accept(builder);
        return this;
    }

    @Deprecated(since="5.8", forRemoval=true)
    public ReactiveOAuth2AuthorizedClientProviderBuilder password() {
        this.builders.computeIfAbsent(PasswordReactiveOAuth2AuthorizedClientProvider.class, k -> new PasswordGrantBuilder());
        return this;
    }

    @Deprecated(since="5.8", forRemoval=true)
    public ReactiveOAuth2AuthorizedClientProviderBuilder password(Consumer<PasswordGrantBuilder> builderConsumer) {
        PasswordGrantBuilder builder = (PasswordGrantBuilder)this.builders.computeIfAbsent(PasswordReactiveOAuth2AuthorizedClientProvider.class, k -> new PasswordGrantBuilder());
        builderConsumer.accept(builder);
        return this;
    }

    public ReactiveOAuth2AuthorizedClientProvider build() {
        List<ReactiveOAuth2AuthorizedClientProvider> authorizedClientProviders = this.builders.values().stream().map(Builder::build).collect(Collectors.toList());
        return new DelegatingReactiveOAuth2AuthorizedClientProvider(authorizedClientProviders);
    }

    public final class RefreshTokenGrantBuilder
    implements Builder {
        private ReactiveOAuth2AccessTokenResponseClient<OAuth2RefreshTokenGrantRequest> accessTokenResponseClient;
        private Duration clockSkew;
        private Clock clock;

        private RefreshTokenGrantBuilder() {
        }

        public RefreshTokenGrantBuilder accessTokenResponseClient(ReactiveOAuth2AccessTokenResponseClient<OAuth2RefreshTokenGrantRequest> accessTokenResponseClient) {
            this.accessTokenResponseClient = accessTokenResponseClient;
            return this;
        }

        public RefreshTokenGrantBuilder clockSkew(Duration clockSkew) {
            this.clockSkew = clockSkew;
            return this;
        }

        public RefreshTokenGrantBuilder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        @Override
        public ReactiveOAuth2AuthorizedClientProvider build() {
            RefreshTokenReactiveOAuth2AuthorizedClientProvider authorizedClientProvider = new RefreshTokenReactiveOAuth2AuthorizedClientProvider();
            if (this.accessTokenResponseClient != null) {
                authorizedClientProvider.setAccessTokenResponseClient(this.accessTokenResponseClient);
            }
            if (this.clockSkew != null) {
                authorizedClientProvider.setClockSkew(this.clockSkew);
            }
            if (this.clock != null) {
                authorizedClientProvider.setClock(this.clock);
            }
            return authorizedClientProvider;
        }
    }

    public final class ClientCredentialsGrantBuilder
    implements Builder {
        private ReactiveOAuth2AccessTokenResponseClient<OAuth2ClientCredentialsGrantRequest> accessTokenResponseClient;
        private Duration clockSkew;
        private Clock clock;

        private ClientCredentialsGrantBuilder() {
        }

        public ClientCredentialsGrantBuilder accessTokenResponseClient(ReactiveOAuth2AccessTokenResponseClient<OAuth2ClientCredentialsGrantRequest> accessTokenResponseClient) {
            this.accessTokenResponseClient = accessTokenResponseClient;
            return this;
        }

        public ClientCredentialsGrantBuilder clockSkew(Duration clockSkew) {
            this.clockSkew = clockSkew;
            return this;
        }

        public ClientCredentialsGrantBuilder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        @Override
        public ReactiveOAuth2AuthorizedClientProvider build() {
            ClientCredentialsReactiveOAuth2AuthorizedClientProvider authorizedClientProvider = new ClientCredentialsReactiveOAuth2AuthorizedClientProvider();
            if (this.accessTokenResponseClient != null) {
                authorizedClientProvider.setAccessTokenResponseClient(this.accessTokenResponseClient);
            }
            if (this.clockSkew != null) {
                authorizedClientProvider.setClockSkew(this.clockSkew);
            }
            if (this.clock != null) {
                authorizedClientProvider.setClock(this.clock);
            }
            return authorizedClientProvider;
        }
    }

    public final class PasswordGrantBuilder
    implements Builder {
        private ReactiveOAuth2AccessTokenResponseClient<OAuth2PasswordGrantRequest> accessTokenResponseClient;
        private Duration clockSkew;
        private Clock clock;

        private PasswordGrantBuilder() {
        }

        public PasswordGrantBuilder accessTokenResponseClient(ReactiveOAuth2AccessTokenResponseClient<OAuth2PasswordGrantRequest> accessTokenResponseClient) {
            this.accessTokenResponseClient = accessTokenResponseClient;
            return this;
        }

        public PasswordGrantBuilder clockSkew(Duration clockSkew) {
            this.clockSkew = clockSkew;
            return this;
        }

        public PasswordGrantBuilder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        @Override
        public ReactiveOAuth2AuthorizedClientProvider build() {
            PasswordReactiveOAuth2AuthorizedClientProvider authorizedClientProvider = new PasswordReactiveOAuth2AuthorizedClientProvider();
            if (this.accessTokenResponseClient != null) {
                authorizedClientProvider.setAccessTokenResponseClient(this.accessTokenResponseClient);
            }
            if (this.clockSkew != null) {
                authorizedClientProvider.setClockSkew(this.clockSkew);
            }
            if (this.clock != null) {
                authorizedClientProvider.setClock(this.clock);
            }
            return authorizedClientProvider;
        }
    }

    public final class AuthorizationCodeGrantBuilder
    implements Builder {
        private AuthorizationCodeGrantBuilder() {
        }

        @Override
        public ReactiveOAuth2AuthorizedClientProvider build() {
            return new AuthorizationCodeReactiveOAuth2AuthorizedClientProvider();
        }
    }

    static interface Builder {
        public ReactiveOAuth2AuthorizedClientProvider build();
    }
}

