/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.run;

import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.cfg.ProcessEnginePlugin;
import io.openbpm.bpm.engine.impl.plugin.AdministratorAuthorizationPlugin;
import io.openbpm.bpm.identity.impl.ldap.plugin.LdapIdentityProviderPlugin;
import io.openbpm.bpm.run.OperatonBpmRunDeploymentConfiguration;
import io.openbpm.bpm.run.OperatonBpmRunProcessEngineConfiguration;
import io.openbpm.bpm.run.property.OperatonBpmRunProperties;
import io.openbpm.bpm.spring.boot.starter.OperatonBpmAutoConfiguration;
import io.openbpm.bpm.spring.boot.starter.property.OperatonBpmProperties;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@EnableConfigurationProperties(value={OperatonBpmRunProperties.class})
@Configuration
@AutoConfigureAfter(value={OperatonBpmAutoConfiguration.class})
public class OperatonBpmRunConfiguration {
    @Bean
    @ConditionalOnProperty(name={"enabled"}, havingValue="true", prefix="openbpm.bpm.run.ldap")
    public LdapIdentityProviderPlugin ldapIdentityProviderPlugin(OperatonBpmRunProperties properties) {
        return properties.getLdap();
    }

    @Bean
    @ConditionalOnProperty(name={"enabled"}, havingValue="true", prefix="openbpm.bpm.run.admin-auth")
    public AdministratorAuthorizationPlugin administratorAuthorizationPlugin(OperatonBpmRunProperties properties) {
        return properties.getAdminAuth();
    }

    @Bean
    public ProcessEngineConfigurationImpl processEngineConfigurationImpl(List<ProcessEnginePlugin> processEnginePluginsFromContext, OperatonBpmRunProperties properties, OperatonBpmRunDeploymentConfiguration deploymentConfig) {
        String normalizedDeploymentDir = deploymentConfig.getNormalizedDeploymentDir();
        boolean deployChangedOnly = properties.getDeployment().isDeployChangedOnly();
        List processEnginePluginsFromYaml = properties.getProcessEnginePlugins();
        return new OperatonBpmRunProcessEngineConfiguration(normalizedDeploymentDir, deployChangedOnly, processEnginePluginsFromContext, processEnginePluginsFromYaml);
    }

    @Bean
    public OperatonBpmRunDeploymentConfiguration operatonDeploymentConfiguration(@Value(value="${openbpm.deploymentDir:#{null}}") String deploymentDir, OperatonBpmProperties operatonBpmProperties) {
        return new OperatonBpmRunDeploymentConfiguration(deploymentDir, operatonBpmProperties);
    }
}

