/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.run;

import io.openbpm.bpm.engine.rest.security.auth.ProcessEngineAuthenticationFilter;
import io.openbpm.bpm.run.property.OperatonBpmRunAuthenticationProperties;
import io.openbpm.bpm.run.property.OperatonBpmRunProperties;
import io.openbpm.bpm.spring.boot.starter.OperatonBpmAutoConfiguration;
import io.openbpm.bpm.spring.boot.starter.rest.OperatonBpmRestInitializer;
import io.openbpm.bpm.spring.boot.starter.rest.OperatonJerseyResourceConfig;
import jakarta.servlet.Filter;
import java.util.Collections;
import org.apache.catalina.filters.CorsFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.servlet.JerseyApplicationPath;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@EnableConfigurationProperties(value={OperatonBpmRunProperties.class})
@Configuration
@AutoConfigureAfter(value={OperatonBpmAutoConfiguration.class})
@ConditionalOnClass(value={OperatonBpmRestInitializer.class})
public class OperatonBpmRunRestConfiguration {
    OperatonBpmRunProperties operatonBpmRunProperties;
    private static final int CORS_FILTER_PRECEDENCE = 0;
    private static final int AUTH_FILTER_PRECEDENCE = 1;

    @Autowired
    public OperatonBpmRunRestConfiguration(OperatonBpmRunProperties operatonBpmRunProperties) {
        this.operatonBpmRunProperties = operatonBpmRunProperties;
    }

    @Bean
    @ConditionalOnProperty(name={"enabled"}, havingValue="true", prefix="openbpm.bpm.run.auth")
    public FilterRegistrationBean<Filter> processEngineAuthenticationFilter(JerseyApplicationPath applicationPath) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setName("openbpm-engine-auth");
        registration.setFilter((Filter)new ProcessEngineAuthenticationFilter());
        registration.setOrder(1);
        String restApiPathPattern = applicationPath.getUrlMapping();
        registration.addUrlPatterns(new String[]{restApiPathPattern});
        OperatonBpmRunAuthenticationProperties properties = this.operatonBpmRunProperties.getAuth();
        if (properties.getAuthentication() == null || "basic".equals(properties.getAuthentication())) {
            registration.addInitParameter("authentication-provider", "io.openbpm.bpm.engine.rest.security.auth.impl.HttpBasicAuthenticationProvider");
        }
        return registration;
    }

    @Bean
    @ConditionalOnProperty(name={"enabled"}, havingValue="true", prefix="openbpm.bpm.run.cors")
    public FilterRegistrationBean<Filter> corsFilter(JerseyApplicationPath applicationPath) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setName("openbpm-engine-cors");
        CorsFilter corsFilter = new CorsFilter();
        registration.setFilter((Filter)corsFilter);
        registration.setOrder(0);
        String restApiPathPattern = applicationPath.getUrlMapping();
        registration.addUrlPatterns(new String[]{restApiPathPattern});
        registration.addInitParameter("cors.allowed.origins", this.operatonBpmRunProperties.getCors().getAllowedOrigins());
        registration.addInitParameter("cors.allowed.methods", "GET,POST,HEAD,OPTIONS,PUT,DELETE");
        registration.addInitParameter("cors.allowed.headers", this.operatonBpmRunProperties.getCors().getAllowedHeaders());
        registration.addInitParameter("cors.exposed.headers", this.operatonBpmRunProperties.getCors().getExposedHeaders());
        registration.addInitParameter("cors.support.credentials", String.valueOf(this.operatonBpmRunProperties.getCors().getAllowCredentials()));
        registration.addInitParameter("cors.preflight.maxage", this.operatonBpmRunProperties.getCors().getPreflightMaxAge());
        return registration;
    }

    @Bean
    public OperatonJerseyResourceConfig operatonRunJerseyResourceConfig() {
        OperatonJerseyResourceConfig operatonJerseyResourceConfig = new OperatonJerseyResourceConfig();
        operatonJerseyResourceConfig.setProperties(Collections.singletonMap("jersey.config.server.wadl.disableWadl", this.operatonBpmRunProperties.getRest().isDisableWadl()));
        return operatonJerseyResourceConfig;
    }
}

