/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.spring.boot.starter.rest;

import io.openbpm.bpm.engine.rest.filter.CacheControlFilter;
import io.openbpm.bpm.engine.rest.filter.EmptyBodyFilter;
import io.openbpm.bpm.spring.boot.starter.property.OperatonBpmProperties;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.ServletContext;
import java.util.EnumSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.servlet.JerseyApplicationPath;
import org.springframework.boot.web.servlet.ServletContextInitializer;

public class OperatonBpmRestInitializer
implements ServletContextInitializer {
    private static final Logger log = LoggerFactory.getLogger(OperatonBpmRestInitializer.class);
    private static final EnumSet<DispatcherType> DISPATCHER_TYPES = EnumSet.of(DispatcherType.REQUEST);
    private ServletContext servletContext;
    private final JerseyApplicationPath applicationPath;
    private final OperatonBpmProperties properties;

    public OperatonBpmRestInitializer(JerseyApplicationPath applicationPath, OperatonBpmProperties properties) {
        this.applicationPath = applicationPath;
        this.properties = properties;
    }

    public void onStartup(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.properties.getRestApi().getFetchAndLock().getInitParams().forEach((arg_0, arg_1) -> ((ServletContext)servletContext).setInitParameter(arg_0, arg_1));
        String restApiPathPattern = this.applicationPath.getUrlMapping();
        this.registerFilter("EmptyBodyFilter", EmptyBodyFilter.class, restApiPathPattern);
        this.registerFilter("CacheControlFilter", CacheControlFilter.class, restApiPathPattern);
    }

    private FilterRegistration registerFilter(String filterName, Class<? extends Filter> filterClass, String ... urlPatterns) {
        return this.registerFilter(filterName, filterClass, (Map<String, String>)null, urlPatterns);
    }

    private FilterRegistration registerFilter(String filterName, Class<? extends Filter> filterClass, Map<String, String> initParameters, String ... urlPatterns) {
        FilterRegistration filterRegistration = this.servletContext.getFilterRegistration(filterName);
        if (filterRegistration == null) {
            filterRegistration = this.servletContext.addFilter(filterName, filterClass);
            filterRegistration.addMappingForUrlPatterns(DISPATCHER_TYPES, true, urlPatterns);
            if (initParameters != null) {
                filterRegistration.setInitParameters(initParameters);
            }
            log.debug("Filter {} for URL {} registered.", (Object)filterName, (Object)urlPatterns);
        }
        return filterRegistration;
    }
}

