/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.spring.boot.starter.webapp;

import io.openbpm.bpm.spring.boot.starter.OperatonBpmAutoConfiguration;
import io.openbpm.bpm.spring.boot.starter.property.OperatonBpmProperties;
import io.openbpm.bpm.spring.boot.starter.property.WebappProperty;
import io.openbpm.bpm.spring.boot.starter.webapp.FaviconResourceResolver;
import io.openbpm.bpm.spring.boot.starter.webapp.OperatonBpmWebappInitializer;
import io.openbpm.bpm.spring.boot.starter.webapp.filter.LazyDelegateFilter;
import io.openbpm.bpm.spring.boot.starter.webapp.filter.LazyInitRegistration;
import io.openbpm.bpm.spring.boot.starter.webapp.filter.ResourceLoaderDependingFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.resource.ResourceResolver;

@Configuration
@ConditionalOnProperty(prefix="openbpm.bpm.webapp", name={"enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={OperatonBpmProperties.class})
@ConditionalOnWebApplication
@AutoConfigureAfter(value={OperatonBpmAutoConfiguration.class})
public class OperatonBpmWebappAutoConfiguration
implements WebMvcConfigurer {
    private final ResourceLoader resourceLoader;
    private final OperatonBpmProperties properties;

    @Autowired
    public OperatonBpmWebappAutoConfiguration(ResourceLoader resourceLoader, OperatonBpmProperties properties) {
        this.resourceLoader = resourceLoader;
        this.properties = properties;
    }

    @Bean
    public OperatonBpmWebappInitializer operatonBpmWebappInitializer() {
        return new OperatonBpmWebappInitializer(this.properties);
    }

    @Bean(name={"resourceLoaderDependingInitHook"})
    public LazyDelegateFilter.InitHook<ResourceLoaderDependingFilter> resourceLoaderDependingInitHook() {
        return filter -> {
            filter.setResourceLoader(this.resourceLoader);
            filter.setWebappProperty(this.properties.getWebapp());
        };
    }

    @Bean
    public LazyInitRegistration lazyInitRegistration() {
        return new LazyInitRegistration();
    }

    @Bean
    public FaviconResourceResolver faviconResourceResolver() {
        return new FaviconResourceResolver();
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        String classpath = "classpath:" + this.properties.getWebapp().getWebjarClasspath();
        WebappProperty webapp = this.properties.getWebapp();
        String applicationPath = webapp.getApplicationPath();
        registry.addResourceHandler(new String[]{applicationPath + "/lib/**"}).addResourceLocations(new String[]{classpath + "/lib/"});
        registry.addResourceHandler(new String[]{applicationPath + "/api/**"}).addResourceLocations(new String[]{"classpath:/api/"});
        registry.addResourceHandler(new String[]{applicationPath + "/app/**"}).addResourceLocations(new String[]{classpath + "/app/"});
        registry.addResourceHandler(new String[]{applicationPath + "/assets/**"}).addResourceLocations(new String[]{classpath + "/assets/"});
        registry.addResourceHandler(new String[]{applicationPath + "/favicon.ico"}).addResourceLocations(new String[]{classpath + "/"}).resourceChain(true).addResolver((ResourceResolver)this.faviconResourceResolver());
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        WebappProperty webapp = this.properties.getWebapp();
        if (webapp.isIndexRedirectEnabled()) {
            String applicationPath = webapp.getApplicationPath();
            registry.addRedirectViewController("/", applicationPath + "/app/");
        }
    }
}

