/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.spring.boot.starter.webapp;

import io.openbpm.bpm.admin.impl.web.AdminApplication;
import io.openbpm.bpm.admin.impl.web.bootstrap.AdminContainerBootstrap;
import io.openbpm.bpm.cockpit.impl.web.CockpitApplication;
import io.openbpm.bpm.cockpit.impl.web.bootstrap.CockpitContainerBootstrap;
import io.openbpm.bpm.engine.rest.filter.CacheControlFilter;
import io.openbpm.bpm.engine.rest.filter.EmptyBodyFilter;
import io.openbpm.bpm.spring.boot.starter.property.OperatonBpmProperties;
import io.openbpm.bpm.spring.boot.starter.property.WebappProperty;
import io.openbpm.bpm.spring.boot.starter.webapp.filter.AppendTrailingSlashFilter;
import io.openbpm.bpm.spring.boot.starter.webapp.filter.LazyProcessEnginesFilter;
import io.openbpm.bpm.spring.boot.starter.webapp.filter.LazySecurityFilter;
import io.openbpm.bpm.tasklist.impl.web.TasklistApplication;
import io.openbpm.bpm.tasklist.impl.web.bootstrap.TasklistContainerBootstrap;
import io.openbpm.bpm.webapp.impl.engine.EngineRestApplication;
import io.openbpm.bpm.webapp.impl.security.auth.AuthenticationFilter;
import io.openbpm.bpm.webapp.impl.security.filter.CsrfPreventionFilter;
import io.openbpm.bpm.webapp.impl.security.filter.SessionCookieFilter;
import io.openbpm.bpm.webapp.impl.security.filter.headersec.HttpHeaderSecurityFilter;
import io.openbpm.bpm.webapp.impl.security.filter.util.HttpSessionMutexListener;
import io.openbpm.bpm.webapp.impl.util.ServletContextUtil;
import io.openbpm.bpm.welcome.impl.web.WelcomeApplication;
import io.openbpm.bpm.welcome.impl.web.bootstrap.WelcomeContainerBootstrap;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.SessionTrackingMode;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.Map;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.ServletContextInitializer;

class OperatonBpmWebappInitializer
implements ServletContextInitializer {
    private static final Logger log = LoggerFactory.getLogger(OperatonBpmWebappInitializer.class);
    private static final EnumSet<DispatcherType> DISPATCHER_TYPES = EnumSet.of(DispatcherType.REQUEST);
    public static final String API_WILDCARD_PATH = "/api/*";
    public static final String APP_WILDCARD_PATH = "/app/*";
    private ServletContext servletContext;
    private final OperatonBpmProperties properties;

    public OperatonBpmWebappInitializer(OperatonBpmProperties properties) {
        this.properties = properties;
    }

    public void onStartup(ServletContext servletContext) {
        this.servletContext = servletContext;
        servletContext.setSessionTrackingModes(Collections.singleton(SessionTrackingMode.COOKIE));
        servletContext.addListener((EventListener)new CockpitContainerBootstrap());
        servletContext.addListener((EventListener)new AdminContainerBootstrap());
        servletContext.addListener((EventListener)new TasklistContainerBootstrap());
        servletContext.addListener((EventListener)new WelcomeContainerBootstrap());
        servletContext.addListener((EventListener)new HttpSessionMutexListener());
        WebappProperty webapp = this.properties.getWebapp();
        String applicationPath = webapp.getApplicationPath();
        ServletContextUtil.setAppPath((String)applicationPath, (ServletContext)servletContext);
        this.registerFilter("AppendTrailingSlashFilter", AppendTrailingSlashFilter.class, applicationPath + "/app", applicationPath + "/app/cockpit", applicationPath + "/app/admin", applicationPath + "/app/tasklist", applicationPath + "/app/welcome");
        this.registerFilter("Authentication Filter", AuthenticationFilter.class, Collections.singletonMap("cacheTimeToLive", this.getAuthCacheTTL(webapp)), applicationPath + API_WILDCARD_PATH, applicationPath + APP_WILDCARD_PATH);
        this.registerFilter("Security Filter", LazySecurityFilter.class, Collections.singletonMap("configFile", webapp.getSecurityConfigFile()), applicationPath + API_WILDCARD_PATH, applicationPath + APP_WILDCARD_PATH);
        this.registerFilter("CsrfPreventionFilter", CsrfPreventionFilter.class, webapp.getCsrf().getInitParams(), applicationPath + API_WILDCARD_PATH, applicationPath + APP_WILDCARD_PATH);
        this.registerFilter("SessionCookieFilter", SessionCookieFilter.class, webapp.getSessionCookie().getInitParams(), applicationPath + API_WILDCARD_PATH, applicationPath + APP_WILDCARD_PATH);
        Map headerSecurityProperties = webapp.getHeaderSecurity().getInitParams();
        this.registerFilter("HttpHeaderSecurity", HttpHeaderSecurityFilter.class, headerSecurityProperties, applicationPath + API_WILDCARD_PATH, applicationPath + APP_WILDCARD_PATH);
        this.registerFilter("Engines Filter", LazyProcessEnginesFilter.class, applicationPath + API_WILDCARD_PATH, applicationPath + APP_WILDCARD_PATH, applicationPath + "/", applicationPath);
        this.registerFilter("EmptyBodyFilter", EmptyBodyFilter.class, applicationPath + API_WILDCARD_PATH, applicationPath + APP_WILDCARD_PATH);
        this.registerFilter("CacheControlFilter", CacheControlFilter.class, applicationPath + API_WILDCARD_PATH, applicationPath + APP_WILDCARD_PATH, applicationPath + "/assets/*");
        this.registerServlet("Cockpit Api", CockpitApplication.class, applicationPath + "/api/cockpit/*");
        this.registerServlet("Admin Api", AdminApplication.class, applicationPath + "/api/admin/*");
        this.registerServlet("Tasklist Api", TasklistApplication.class, applicationPath + "/api/tasklist/*");
        this.registerServlet("Engine Api", EngineRestApplication.class, applicationPath + "/api/engine/*");
        this.registerServlet("Welcome Api", WelcomeApplication.class, applicationPath + "/api/welcome/*");
    }

    protected String getAuthCacheTTL(WebappProperty webapp) {
        long authCacheTTL = webapp.getAuth().getCache().getTimeToLive();
        boolean authCacheTTLEnabled = webapp.getAuth().getCache().isTtlEnabled();
        if (authCacheTTLEnabled) {
            return Long.toString(authCacheTTL);
        }
        return "";
    }

    private FilterRegistration registerFilter(String filterName, Class<? extends Filter> filterClass, String ... urlPatterns) {
        return this.registerFilter(filterName, filterClass, (Map<String, String>)null, urlPatterns);
    }

    private FilterRegistration registerFilter(String filterName, Class<? extends Filter> filterClass, Map<String, String> initParameters, String ... urlPatterns) {
        FilterRegistration filterRegistration = this.servletContext.getFilterRegistration(filterName);
        if (filterRegistration == null) {
            filterRegistration = this.servletContext.addFilter(filterName, filterClass);
            filterRegistration.addMappingForUrlPatterns(DISPATCHER_TYPES, true, urlPatterns);
            if (initParameters != null) {
                filterRegistration.setInitParameters(initParameters);
            }
            log.debug("Filter {} for URL {} registered.", (Object)filterName, (Object)urlPatterns);
        }
        return filterRegistration;
    }

    private ServletRegistration registerServlet(String servletName, Class<?> applicationClass, String ... urlPatterns) {
        ServletRegistration servletRegistration = this.servletContext.getServletRegistration(servletName);
        if (servletRegistration == null) {
            servletRegistration = this.servletContext.addServlet(servletName, ServletContainer.class);
            servletRegistration.addMapping(urlPatterns);
            servletRegistration.setInitParameters(Collections.singletonMap("jakarta.ws.rs.Application", applicationClass.getName()));
            log.debug("Servlet {} for URL {} registered.", (Object)servletName, (Object)urlPatterns);
        }
        return servletRegistration;
    }
}

