/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.spring.boot.starter.security.oauth2;

import io.openbpm.bpm.engine.spring.SpringProcessEngineServicesConfiguration;
import io.openbpm.bpm.spring.boot.starter.OperatonBpmAutoConfiguration;
import io.openbpm.bpm.spring.boot.starter.property.OperatonBpmProperties;
import io.openbpm.bpm.spring.boot.starter.property.WebappProperty;
import io.openbpm.bpm.spring.boot.starter.security.oauth2.OAuth2Properties;
import io.openbpm.bpm.spring.boot.starter.security.oauth2.impl.AuthorizeTokenFilter;
import io.openbpm.bpm.spring.boot.starter.security.oauth2.impl.OAuth2AuthenticationProvider;
import io.openbpm.bpm.spring.boot.starter.security.oauth2.impl.OAuth2GrantedAuthoritiesMapper;
import io.openbpm.bpm.spring.boot.starter.security.oauth2.impl.OAuth2IdentityProviderPlugin;
import io.openbpm.bpm.spring.boot.starter.security.oauth2.impl.SsoLogoutSuccessHandler;
import io.openbpm.bpm.webapp.impl.security.auth.ContainerBasedAuthenticationFilter;
import jakarta.annotation.Nullable;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.client.ConditionalOnOAuth2ClientRegistrationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestRedirectFilter;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

@AutoConfigureOrder(value=-2147483548)
@AutoConfigureAfter(value={OperatonBpmAutoConfiguration.class, SpringProcessEngineServicesConfiguration.class})
@ConditionalOnBean(value={OperatonBpmProperties.class})
@ConditionalOnOAuth2ClientRegistrationProperties
@EnableConfigurationProperties(value={OAuth2Properties.class})
public class OperatonSpringSecurityOAuth2AutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(OperatonSpringSecurityOAuth2AutoConfiguration.class);
    public static final int OPERATON_OAUTH2_ORDER = -2147483548;
    private final OAuth2Properties oAuth2Properties;
    private final String webappPath;

    public OperatonSpringSecurityOAuth2AutoConfiguration(OperatonBpmProperties properties, OAuth2Properties oAuth2Properties) {
        this.oAuth2Properties = oAuth2Properties;
        WebappProperty webapp = properties.getWebapp();
        this.webappPath = webapp.getApplicationPath();
    }

    @Bean
    public FilterRegistrationBean<?> webappAuthenticationFilter() {
        FilterRegistrationBean filterRegistration = new FilterRegistrationBean();
        filterRegistration.setName("Container Based Authentication Filter");
        filterRegistration.setFilter((Filter)new ContainerBasedAuthenticationFilter());
        filterRegistration.setInitParameters(Map.of("authentication-provider", OAuth2AuthenticationProvider.class.getName()));
        filterRegistration.setOrder(-99);
        filterRegistration.addUrlPatterns(new String[]{this.webappPath + "/app/*", this.webappPath + "/api/*"});
        filterRegistration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[0]);
        return filterRegistration;
    }

    @Bean
    @ConditionalOnProperty(name={"identity-provider.enabled"}, havingValue="true", prefix="openbpm.bpm.oauth2", matchIfMissing=true)
    public OAuth2IdentityProviderPlugin identityProviderPlugin() {
        logger.debug("Registering OAuth2IdentityProviderPlugin");
        return new OAuth2IdentityProviderPlugin();
    }

    @Bean
    @ConditionalOnProperty(name={"identity-provider.group-name-attribute"}, prefix="openbpm.bpm.oauth2")
    protected GrantedAuthoritiesMapper grantedAuthoritiesMapper() {
        logger.debug("Registering OAuth2GrantedAuthoritiesMapper");
        return new OAuth2GrantedAuthoritiesMapper(this.oAuth2Properties);
    }

    @Bean
    @ConditionalOnProperty(name={"sso-logout.enabled"}, havingValue="true", prefix="openbpm.bpm.oauth2")
    protected SsoLogoutSuccessHandler ssoLogoutSuccessHandler(ClientRegistrationRepository clientRegistrationRepository) {
        logger.debug("Registering SsoLogoutSuccessHandler");
        return new SsoLogoutSuccessHandler(clientRegistrationRepository, this.oAuth2Properties);
    }

    @Bean
    protected AuthorizeTokenFilter authorizeTokenFilter(OAuth2AuthorizedClientManager clientManager) {
        logger.debug("Registering AuthorizeTokenFilter");
        return new AuthorizeTokenFilter(clientManager);
    }

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http, AuthorizeTokenFilter authorizeTokenFilter, @Nullable SsoLogoutSuccessHandler ssoLogoutSuccessHandler) throws Exception {
        logger.info("Enabling OpenBPM Engine Spring Security oauth2 integration");
        http.authorizeHttpRequests(c -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)c.requestMatchers(new String[]{this.webappPath + "/app/**"})).authenticated().requestMatchers(new String[]{this.webappPath + "/api/**"})).authenticated().anyRequest()).permitAll()).addFilterAfter((Filter)authorizeTokenFilter, OAuth2AuthorizationRequestRedirectFilter.class).anonymous(AbstractHttpConfigurer::disable).oidcLogout(c -> c.backChannel(Customizer.withDefaults())).oauth2Login(Customizer.withDefaults()).logout(c -> c.clearAuthentication(true).invalidateHttpSession(true)).oauth2Client(Customizer.withDefaults()).cors(AbstractHttpConfigurer::disable).csrf(AbstractHttpConfigurer::disable);
        if (this.oAuth2Properties.getSsoLogout().isEnabled()) {
            http.logout(c -> c.logoutSuccessHandler((LogoutSuccessHandler)ssoLogoutSuccessHandler));
        }
        return (SecurityFilterChain)http.build();
    }
}

