/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.admin.impl.plugin.base.dto;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.impl.metrics.util.MetricsUtil;
import io.openbpm.bpm.engine.impl.util.ClockUtil;
import io.openbpm.bpm.engine.rest.dto.OperatonQueryParam;
import io.openbpm.bpm.engine.rest.dto.converter.DateConverter;
import io.openbpm.bpm.engine.rest.dto.converter.StringListConverter;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import io.openbpm.bpm.webapp.rest.dto.AbstractRestQueryParametersDto;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class MetricsAggregatedQueryDto
extends AbstractRestQueryParametersDto<MetricsAggregatedQueryDto> {
    private static final Set<String> VALID_GROUP_BY_VALUES = new HashSet<String>();
    private static final Set<String> VALID_METRIC_VALUES;
    protected String groupBy;
    protected Set<String> metrics;
    protected Date subscriptionStartDate;
    protected Date startDate;
    protected Date endDate;
    protected int subscriptionMonth;
    protected int subscriptionDay;

    public MetricsAggregatedQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
        this.maxResultsLimitEnabled = false;
    }

    @OperatonQueryParam(value="groupBy")
    public void setGroupBy(String groupBy) {
        this.groupBy = groupBy;
    }

    public String getGroupBy() {
        return this.groupBy;
    }

    @OperatonQueryParam(value="metrics", converter=StringListConverter.class)
    public void setMetrics(List<String> metrics) {
        boolean valid = new HashSet<String>(VALID_METRIC_VALUES).containsAll(metrics);
        if (!valid) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "metrics parameter has invalid value: " + metrics);
        }
        this.metrics = new HashSet<String>(metrics);
    }

    public Set<String> getMetrics() {
        return this.metrics;
    }

    @OperatonQueryParam(value="subscriptionStartDate", converter=DateConverter.class)
    public void setSubscriptionStartDate(Date subscriptionStartDate) {
        this.subscriptionStartDate = subscriptionStartDate;
        if (subscriptionStartDate != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(subscriptionStartDate);
            this.subscriptionMonth = cal.get(2) + 1;
            this.subscriptionDay = cal.get(5);
        }
    }

    @OperatonQueryParam(value="startDate", converter=DateConverter.class)
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @OperatonQueryParam(value="endDate", converter=DateConverter.class)
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Override
    protected String getOrderByValue(String sortBy) {
        return null;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return false;
    }

    public void validateAndPrepareQuery() {
        if (this.subscriptionStartDate == null || !this.subscriptionStartDate.before(ClockUtil.now())) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "subscriptionStartDate parameter has invalid value: " + this.subscriptionStartDate);
        }
        if (this.startDate != null && this.endDate != null && !this.endDate.after(this.startDate)) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "endDate parameter must be after startDate");
        }
        if (!VALID_GROUP_BY_VALUES.contains(this.groupBy)) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "groupBy parameter has invalid value: " + this.groupBy);
        }
        if (this.metrics == null || this.metrics.isEmpty()) {
            this.metrics = VALID_METRIC_VALUES;
        }
        this.metrics = this.metrics.stream().map(MetricsUtil::resolveInternalName).collect(Collectors.toSet());
    }

    public int getSubscriptionMonth() {
        return this.subscriptionMonth;
    }

    public int getSubscriptionDay() {
        return this.subscriptionDay;
    }

    static {
        VALID_GROUP_BY_VALUES.add("year");
        VALID_GROUP_BY_VALUES.add("month");
        VALID_METRIC_VALUES = new HashSet<String>();
        VALID_METRIC_VALUES.add("process-instances");
        VALID_METRIC_VALUES.add("decision-instances");
        VALID_METRIC_VALUES.add("flow-node-instances");
        VALID_METRIC_VALUES.add("executed-decision-elements");
        VALID_METRIC_VALUES.add("task-users");
    }
}

