/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.admin.impl.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.AuthorizationService;
import io.openbpm.bpm.engine.IdentityService;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.authorization.Authorization;
import io.openbpm.bpm.engine.authorization.Permission;
import io.openbpm.bpm.engine.authorization.Permissions;
import io.openbpm.bpm.engine.authorization.Resource;
import io.openbpm.bpm.engine.authorization.Resources;
import io.openbpm.bpm.engine.identity.Group;
import io.openbpm.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import io.openbpm.bpm.engine.rest.dto.identity.UserDto;
import io.openbpm.bpm.engine.rest.impl.UserRestServiceImpl;
import io.openbpm.bpm.engine.rest.spi.ProcessEngineProvider;
import io.openbpm.bpm.engine.rest.util.ProvidersUtil;
import io.openbpm.bpm.webapp.impl.WebappLogger;
import io.openbpm.bpm.webapp.impl.security.SecurityActions;
import jakarta.servlet.ServletException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.util.Iterator;
import java.util.ServiceLoader;

@Path(value="/setup/{engine}")
public class SetupResource {
    protected static final WebappLogger LOGGER = WebappLogger.INSTANCE;
    @Context
    protected Providers providers;

    @Path(value="/user/create")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void createInitialUser(@PathParam(value="engine") String processEngineName, UserDto user) throws IOException, ServletException {
        ProcessEngine processEngine = this.lookupProcessEngine(processEngineName);
        if (processEngine == null) {
            throw LOGGER.invalidRequestEngineNotFoundForName(processEngineName);
        }
        SecurityActions.runWithoutAuthentication(() -> {
            this.createInitialUserInternal(processEngineName, user, processEngine);
            return null;
        }, processEngine);
    }

    protected void createInitialUserInternal(String processEngineName, UserDto user, ProcessEngine processEngine) {
        ObjectMapper objectMapper = this.getObjectMapper();
        this.ensureSetupAvailable(processEngine);
        UserRestServiceImpl userRestServiceImpl = new UserRestServiceImpl(processEngineName, objectMapper);
        userRestServiceImpl.createUser(user);
        this.ensureOperatonAdminGroupExists(processEngine);
        processEngine.getIdentityService().createMembership(user.getProfile().getId(), "openbpm-engine-admin");
    }

    protected ObjectMapper getObjectMapper() {
        if (this.providers != null) {
            return (ObjectMapper)ProvidersUtil.resolveFromContext((Providers)this.providers, ObjectMapper.class, (MediaType)MediaType.APPLICATION_JSON_TYPE, this.getClass());
        }
        return null;
    }

    protected void ensureOperatonAdminGroupExists(ProcessEngine processEngine) {
        IdentityService identityService = processEngine.getIdentityService();
        AuthorizationService authorizationService = processEngine.getAuthorizationService();
        if (identityService.createGroupQuery().groupId("openbpm-engine-admin").count() == 0L) {
            Group operatonAdminGroup = identityService.newGroup("openbpm-engine-admin");
            operatonAdminGroup.setName("operaton BPM Administrators");
            operatonAdminGroup.setType("SYSTEM");
            identityService.saveGroup(operatonAdminGroup);
        }
        for (Resources resource : Resources.values()) {
            if (authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"openbpm-engine-admin"}).resourceType((Resource)resource).resourceId("*").count() != 0L) continue;
            AuthorizationEntity userAdminAuth = new AuthorizationEntity(1);
            userAdminAuth.setGroupId("openbpm-engine-admin");
            userAdminAuth.setResource((Resource)resource);
            userAdminAuth.setResourceId("*");
            userAdminAuth.addPermission((Permission)Permissions.ALL);
            authorizationService.saveAuthorization((Authorization)userAdminAuth);
        }
    }

    protected void ensureSetupAvailable(ProcessEngine processEngine) {
        if (processEngine.getIdentityService().isReadOnly() || processEngine.getIdentityService().createUserQuery().memberOfGroup("openbpm-engine-admin").count() > 0L) {
            throw LOGGER.setupActionNotAvailable();
        }
    }

    protected ProcessEngine lookupProcessEngine(String engineName) {
        ServiceLoader<ProcessEngineProvider> serviceLoader = ServiceLoader.load(ProcessEngineProvider.class);
        Iterator<ProcessEngineProvider> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            ProcessEngineProvider provider = iterator.next();
            return provider.getProcessEngine(engineName);
        }
        throw LOGGER.processEngineProviderNotFound();
    }
}

