/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.cockpit.impl.plugin.resources;

import io.openbpm.bpm.cockpit.impl.plugin.base.dto.IncidentDto;
import io.openbpm.bpm.cockpit.impl.plugin.base.dto.query.IncidentQueryDto;
import io.openbpm.bpm.cockpit.plugin.resource.AbstractPluginResource;
import io.openbpm.bpm.engine.authorization.Permission;
import io.openbpm.bpm.engine.authorization.Permissions;
import io.openbpm.bpm.engine.authorization.Resource;
import io.openbpm.bpm.engine.authorization.Resources;
import io.openbpm.bpm.engine.rest.dto.CountResultDto;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;

@Produces(value={"application/json"})
public class IncidentRestService
extends AbstractPluginResource {
    public static final String PATH = "/incident";

    public IncidentRestService(String engineName) {
        super(engineName);
    }

    @GET
    @Produces(value={"application/json"})
    public List<IncidentDto> getIncidents(@Context UriInfo uriInfo, @QueryParam(value="firstResult") Integer firstResult, @QueryParam(value="maxResults") Integer maxResults) {
        IncidentQueryDto queryParameter = new IncidentQueryDto((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryIncidents(queryParameter, firstResult, maxResults);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public List<IncidentDto> queryIncidents(IncidentQueryDto queryParameter, @QueryParam(value="firstResult") Integer firstResult, @QueryParam(value="maxResults") Integer maxResults) {
        this.paginateQueryParameters(queryParameter, firstResult, maxResults);
        this.configureExecutionQuery(queryParameter);
        return this.getQueryService().executeQuery("selectIncidentWithCauseAndRootCauseIncidents", queryParameter);
    }

    private void paginateQueryParameters(IncidentQueryDto queryParameter, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        queryParameter.setFirstResult(firstResult);
        queryParameter.setMaxResults(maxResults);
    }

    @GET
    @Path(value="/count")
    @Produces(value={"application/json"})
    public CountResultDto getIncidentsCount(@Context UriInfo uriInfo) {
        IncidentQueryDto queryParameter = new IncidentQueryDto((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryIncidentsCount(queryParameter);
    }

    @POST
    @Path(value="/count")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public CountResultDto queryIncidentsCount(IncidentQueryDto queryParameter) {
        CountResultDto result = new CountResultDto();
        this.configureExecutionQuery(queryParameter);
        long count = this.getQueryService().executeQueryRowCount("selectIncidentWithCauseAndRootCauseIncidentsCount", queryParameter);
        result.setCount(count);
        return result;
    }

    protected void configureExecutionQuery(IncidentQueryDto query) {
        this.configureAuthorizationCheck(query);
        this.configureTenantCheck(query);
        this.addPermissionCheck(query, (Resource)Resources.PROCESS_INSTANCE, "RES.PROC_INST_ID_", (Permission)Permissions.READ);
        this.addPermissionCheck(query, (Resource)Resources.PROCESS_DEFINITION, "PROCDEF.KEY_", (Permission)Permissions.READ_INSTANCE);
    }
}

