/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.cockpit.rest.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.cockpit.db.QueryParameters;
import io.openbpm.bpm.engine.rest.dto.OperatonQueryParam;
import io.openbpm.bpm.engine.rest.dto.converter.StringToTypeConverter;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import io.openbpm.bpm.engine.rest.exception.RestException;
import io.openbpm.bpm.engine.variable.Variables;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public abstract class AbstractRestQueryParametersDto<T>
extends QueryParameters {
    protected static final String DEFAULT_ORDER = "RES.ID_ asc";
    private static final long serialVersionUID = 1L;
    protected static final String SORT_ORDER_ASC_VALUE = "asc";
    protected static final String SORT_ORDER_DESC_VALUE = "desc";
    private static final List<String> VALID_SORT_ORDER_VALUES = new ArrayList<String>();
    protected String sortBy;
    protected String sortOrder;
    protected ObjectMapper objectMapper;

    protected AbstractRestQueryParametersDto() {
    }

    protected AbstractRestQueryParametersDto(MultivaluedMap<String, String> queryParameters) {
        for (Map.Entry param : queryParameters.entrySet()) {
            String key = (String)param.getKey();
            String value = (String)((List)param.getValue()).iterator().next();
            this.setValueBasedOnAnnotation(key, value);
        }
        if (!this.sortOptionsValid()) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Only a single sorting parameter specified. sortBy and sortOrder required");
        }
    }

    @OperatonQueryParam(value="sortBy")
    public void setSortBy(String sortBy) {
        if (!this.isValidSortByValue(sortBy)) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "sortBy parameter has invalid value: " + sortBy);
        }
        this.sortBy = sortBy;
    }

    @OperatonQueryParam(value="sortOrder")
    public void setSortOrder(String sortOrder) {
        if (!VALID_SORT_ORDER_VALUES.contains(sortOrder)) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "sortOrder parameter has invalid value: " + sortOrder);
        }
        this.sortOrder = sortOrder;
    }

    protected boolean sortOptionsValid() {
        return this.sortBy != null && this.sortOrder != null || this.sortBy == null && this.sortOrder == null;
    }

    public String getInternalOrderBy() {
        return this.getOrderBy();
    }

    @Deprecated(since="1.0")
    public String getOrderBy() {
        if (this.sortBy != null) {
            if (this.sortOrder == null || this.sortOrder.isEmpty()) {
                this.sortOrder = SORT_ORDER_ASC_VALUE;
            }
            return "%s %s".formatted(this.getOrderByValue(this.sortBy), this.sortOrder);
        }
        return DEFAULT_ORDER;
    }

    protected abstract String getOrderByValue(String var1);

    protected abstract boolean isValidSortByValue(String var1);

    protected Object resolveVariableValue(Object value) {
        if (value != null && Number.class.isAssignableFrom(value.getClass())) {
            return Variables.numberValue((Number)((Number)value));
        }
        if (value != null && this.objectMapper != null) {
            try {
                return this.objectMapper.readValue("\"" + value + "\"", Date.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    protected void setValueBasedOnAnnotation(String key, String value) {
        List<Method> matchingMethods = this.findMatchingAnnotatedMethods(key);
        for (Method method : matchingMethods) {
            Class<StringToTypeConverter<?>> converterClass = this.findAnnotatedTypeConverter(method);
            if (converterClass == null) continue;
            StringToTypeConverter<?> converter = null;
            try {
                converter = converterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Object convertedValue = converter.convertQueryParameterToType(value);
                method.invoke((Object)this, convertedValue);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)e, "Server error.");
            }
            catch (InvocationTargetException e) {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)e, "Cannot set query parameter '" + key + "' to value '" + value + "'");
            }
            catch (RestException e) {
                throw new InvalidRequestException(e.getStatus(), (Exception)((Object)e), "Cannot set query parameter '" + key + "' to value '" + value + "': " + e.getMessage());
            }
        }
    }

    private List<Method> findMatchingAnnotatedMethods(String parameterName) {
        ArrayList<Method> result = new ArrayList<Method>();
        Method[] methods = ((Object)((Object)this)).getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            Annotation[] methodAnnotations = method.getAnnotations();
            for (int j = 0; j < methodAnnotations.length; ++j) {
                OperatonQueryParam parameterAnnotation;
                Annotation annotation = methodAnnotations[j];
                if (!(annotation instanceof OperatonQueryParam) || !(parameterAnnotation = (OperatonQueryParam)annotation).value().equals(parameterName)) continue;
                result.add(method);
            }
        }
        return result;
    }

    private Class<? extends StringToTypeConverter<?>> findAnnotatedTypeConverter(Method method) {
        Annotation[] methodAnnotations = method.getAnnotations();
        for (int j = 0; j < methodAnnotations.length; ++j) {
            Annotation annotation = methodAnnotations[j];
            if (!(annotation instanceof OperatonQueryParam)) continue;
            OperatonQueryParam parameterAnnotation = (OperatonQueryParam)annotation;
            return parameterAnnotation.converter();
        }
        return null;
    }

    @JsonIgnore
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    static {
        VALID_SORT_ORDER_VALUES.add(SORT_ORDER_ASC_VALUE);
        VALID_SORT_ORDER_VALUES.add(SORT_ORDER_DESC_VALUE);
    }
}

