/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.webapp.impl.db;

import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.db.AuthorizationCheck;
import io.openbpm.bpm.engine.impl.db.ListQueryParameterObject;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.util.QueryMaxResultsLimitUtil;
import io.openbpm.bpm.webapp.db.CommandExecutor;
import io.openbpm.bpm.webapp.db.QueryParameters;
import io.openbpm.bpm.webapp.db.QueryService;
import io.openbpm.bpm.webapp.impl.db.QuerySessionFactory;
import java.util.List;

public class QueryServiceImpl
implements QueryService {
    private final CommandExecutor commandExecutor;

    public QueryServiceImpl(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    @Override
    public <T> List<T> executeQuery(String statement, QueryParameters parameter) {
        return (List)this.commandExecutor.executeCommand(new ExecuteListQueryCmd(statement, parameter));
    }

    public <T> T executeQuery(String statement, Object parameter, Class<T> clazz) {
        return this.commandExecutor.executeCommand(new ExecuteSingleQueryCmd<T>(statement, parameter, clazz));
    }

    @Override
    public Long executeQueryRowCount(String statement, ListQueryParameterObject parameter) {
        return this.commandExecutor.executeCommand(new QueryServiceRowCountCmd(statement, parameter));
    }

    protected ProcessEngineConfigurationImpl getProcessEngineConfiguration(CommandContext commandContext) {
        QuerySessionFactory querySessionFactory = (QuerySessionFactory)commandContext.getProcessEngineConfiguration();
        ProcessEngineConfigurationImpl processEngineConfiguration = null;
        if (querySessionFactory != null) {
            processEngineConfiguration = querySessionFactory.getWrappedConfiguration();
        }
        if (processEngineConfiguration == null) {
            throw new ProcessEngineException("Process Engine Configuration missing!");
        }
        return processEngineConfiguration;
    }

    protected void configureAuthCheck(ListQueryParameterObject parameter, ProcessEngineConfigurationImpl engineConfig, CommandContext commandContext) {
        AuthorizationCheck authCheck = parameter.getAuthCheck();
        commandContext.getAuthorizationManager().enableQueryAuthCheck(authCheck);
        boolean isEnableHistoricInstancePermissions = engineConfig.isEnableHistoricInstancePermissions();
        authCheck.setHistoricInstancePermissionsEnabled(isEnableHistoricInstancePermissions);
    }

    protected class ExecuteListQueryCmd<T>
    implements Command<List<T>> {
        protected String statement;
        protected QueryParameters parameter;

        public ExecuteListQueryCmd(String statement, QueryParameters parameter) {
            this.statement = statement;
            this.parameter = parameter;
        }

        public List<T> execute(CommandContext commandContext) {
            ProcessEngineConfigurationImpl engineConfig = QueryServiceImpl.this.getProcessEngineConfiguration(commandContext);
            QueryServiceImpl.this.configureAuthCheck(this.parameter, engineConfig, commandContext);
            if (this.parameter.isMaxResultsLimitEnabled()) {
                QueryMaxResultsLimitUtil.checkMaxResultsLimit((int)this.parameter.getMaxResults(), (ProcessEngineConfigurationImpl)engineConfig);
            }
            return commandContext.getDbSqlSession().selectList(this.statement, (Object)this.parameter);
        }
    }

    protected class ExecuteSingleQueryCmd<T>
    implements Command<T> {
        protected String statement;
        protected Object parameter;
        protected Class<T> clazz;

        public ExecuteSingleQueryCmd(String statement, Object parameter, Class<T> clazz) {
            this.statement = statement;
            this.parameter = parameter;
            this.clazz = clazz;
        }

        public T execute(CommandContext commandContext) {
            return (T)commandContext.getDbSqlSession().selectOne(this.statement, this.parameter);
        }
    }

    protected class QueryServiceRowCountCmd
    implements Command<Long> {
        protected String statement;
        protected ListQueryParameterObject parameter;

        public QueryServiceRowCountCmd(String statement, ListQueryParameterObject parameter) {
            this.statement = statement;
            this.parameter = parameter;
        }

        public Long execute(CommandContext commandContext) {
            ProcessEngineConfigurationImpl engineConfig = QueryServiceImpl.this.getProcessEngineConfiguration(commandContext);
            QueryServiceImpl.this.configureAuthCheck(this.parameter, engineConfig, commandContext);
            return (Long)commandContext.getDbSqlSession().selectOne(this.statement, (Object)this.parameter);
        }
    }
}

