/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.webapp.impl.security.filter.headersec.provider.impl;

import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.webapp.impl.security.filter.headersec.provider.HeaderSecurityProvider;
import io.openbpm.bpm.webapp.impl.security.filter.headersec.provider.impl.XssProtectionOption;
import io.openbpm.bpm.webapp.impl.util.ServletFilterUtil;
import java.util.Map;

public class XssProtectionProvider
extends HeaderSecurityProvider {
    public static final String HEADER_NAME = "X-XSS-Protection";
    public static final XssProtectionOption HEADER_DEFAULT_VALUE = XssProtectionOption.BLOCK;
    public static final String DISABLED_PARAM = "xssProtectionDisabled";
    public static final String OPTION_PARAM = "xssProtectionOption";
    public static final String VALUE_PARAM = "xssProtectionValue";

    @Override
    public Map<String, String> initParams() {
        this.initParams.put(DISABLED_PARAM, null);
        this.initParams.put(OPTION_PARAM, null);
        this.initParams.put(VALUE_PARAM, null);
        return this.initParams;
    }

    @Override
    public void parseParams() {
        String disabled = (String)this.initParams.get(DISABLED_PARAM);
        if (ServletFilterUtil.isEmpty(disabled)) {
            this.setDisabled(false);
        } else {
            this.setDisabled(Boolean.parseBoolean(disabled));
        }
        String value = (String)this.initParams.get(VALUE_PARAM);
        String option = (String)this.initParams.get(OPTION_PARAM);
        if (!this.isDisabled()) {
            if (!ServletFilterUtil.isEmpty(value) && !ServletFilterUtil.isEmpty(option)) {
                throw new ProcessEngineException(this.getClass().getSimpleName() + ": cannot set both xssProtectionValue and xssProtectionOption.");
            }
            if (!ServletFilterUtil.isEmpty(value)) {
                this.setValue(value);
            } else if (!ServletFilterUtil.isEmpty(option)) {
                this.setValue(this.parseValue(option).getHeaderValue());
            } else {
                this.setValue(HEADER_DEFAULT_VALUE.getHeaderValue());
            }
        }
    }

    protected XssProtectionOption parseValue(String optionValue) {
        for (XssProtectionOption option : XssProtectionOption.values()) {
            if (!option.getName().equalsIgnoreCase(optionValue)) continue;
            return option;
        }
        throw new ProcessEngineException(this.getClass().getSimpleName() + ": cannot set non-existing option " + optionValue + " for xssProtectionOption.");
    }

    @Override
    public String getHeaderName() {
        return HEADER_NAME;
    }
}

