/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.run;

import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.impl.cfg.CompositeProcessEnginePlugin;
import io.openbpm.bpm.engine.impl.cfg.ProcessEnginePlugin;
import io.openbpm.bpm.engine.spring.SpringProcessEngineConfiguration;
import io.openbpm.bpm.run.property.OperatonBpmRunProcessEnginePluginProperty;
import io.openbpm.bpm.run.utils.OperatonBpmRunProcessEnginePluginHelper;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.springframework.core.io.Resource;

public class OperatonBpmRunProcessEngineConfiguration
extends SpringProcessEngineConfiguration {
    private final String normalizedDeploymentDir;

    public OperatonBpmRunProcessEngineConfiguration(String normalizedDeploymentDir, boolean deployChangedOnly, List<ProcessEnginePlugin> processEnginePluginsFromContext, List<OperatonBpmRunProcessEnginePluginProperty> processEnginePluginsFromYaml) {
        this.normalizedDeploymentDir = normalizedDeploymentDir;
        this.setDeployChangedOnly(deployChangedOnly);
        this.configureProcessEnginePlugins(processEnginePluginsFromContext, processEnginePluginsFromYaml);
    }

    protected String getFileResourceName(Resource resource) {
        try {
            String resourceAbsolutePath = resource.getURI().toString();
            int startIndex = resourceAbsolutePath.indexOf(this.normalizedDeploymentDir) + this.normalizedDeploymentDir.length();
            return resourceAbsolutePath.substring(startIndex);
        }
        catch (IOException e) {
            throw new ProcessEngineException("Failed to locate resource " + resource.getFilename(), (Throwable)e);
        }
    }

    protected void initTelemetryData() {
        super.initTelemetryData();
        Set operatonIntegration = this.telemetryData.getProduct().getInternals().getOperatonIntegration();
        operatonIntegration.add("openbpm-engine-bpm-run");
    }

    protected void configureProcessEnginePlugins(List<ProcessEnginePlugin> processEnginePluginsFromContext, List<OperatonBpmRunProcessEnginePluginProperty> processEnginePluginsFromYaml) {
        OperatonBpmRunProcessEnginePluginHelper.registerYamlPlugins(processEnginePluginsFromContext, processEnginePluginsFromYaml);
        this.processEnginePlugins.add(new CompositeProcessEnginePlugin(processEnginePluginsFromContext));
    }
}

