/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.model.cmmn.impl.instance;

import io.openbpm.bpm.model.cmmn.impl.instance.CmmnAttributeElementReferenceCollection;
import io.openbpm.bpm.model.cmmn.impl.instance.CmmnElementImpl;
import io.openbpm.bpm.model.cmmn.instance.CmmnElement;
import io.openbpm.bpm.model.cmmn.instance.EntryCriterion;
import io.openbpm.bpm.model.cmmn.instance.ExitCriterion;
import io.openbpm.bpm.model.cmmn.instance.ItemControl;
import io.openbpm.bpm.model.cmmn.instance.PlanItem;
import io.openbpm.bpm.model.cmmn.instance.PlanItemDefinition;
import io.openbpm.bpm.model.cmmn.instance.Sentry;
import io.openbpm.bpm.model.xml.ModelBuilder;
import io.openbpm.bpm.model.xml.impl.instance.ModelTypeInstanceContext;
import io.openbpm.bpm.model.xml.instance.ModelElementInstance;
import io.openbpm.bpm.model.xml.type.ModelElementTypeBuilder;
import io.openbpm.bpm.model.xml.type.attribute.Attribute;
import io.openbpm.bpm.model.xml.type.child.ChildElement;
import io.openbpm.bpm.model.xml.type.child.ChildElementCollection;
import io.openbpm.bpm.model.xml.type.child.SequenceBuilder;
import io.openbpm.bpm.model.xml.type.reference.AttributeReference;
import io.openbpm.bpm.model.xml.type.reference.AttributeReferenceCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class PlanItemImpl
extends CmmnElementImpl
implements PlanItem {
    protected static Attribute<String> nameAttribute;
    protected static AttributeReference<PlanItemDefinition> planItemDefinitionRefAttribute;
    protected static ChildElement<ItemControl> itemControlChild;
    @Deprecated(since="1.0")
    protected static AttributeReferenceCollection<Sentry> entryCriteriaRefCollection;
    @Deprecated(since="1.0")
    protected static AttributeReferenceCollection<Sentry> exitCriteriaRefCollection;
    protected static ChildElementCollection<EntryCriterion> entryCriterionCollection;
    protected static ChildElementCollection<ExitCriterion> exitCriterionCollection;

    public PlanItemImpl(ModelTypeInstanceContext instanceContext) {
        super(instanceContext);
    }

    @Override
    public String getName() {
        return (String)nameAttribute.getValue((ModelElementInstance)this);
    }

    @Override
    public void setName(String name) {
        nameAttribute.setValue((ModelElementInstance)this, (Object)name);
    }

    @Override
    public PlanItemDefinition getDefinition() {
        return (PlanItemDefinition)planItemDefinitionRefAttribute.getReferenceTargetElement((ModelElementInstance)this);
    }

    @Override
    public void setDefinition(PlanItemDefinition definition) {
        planItemDefinitionRefAttribute.setReferenceTargetElement((ModelElementInstance)this, (ModelElementInstance)definition);
    }

    @Override
    public Collection<Sentry> getEntryCriterias() {
        return entryCriteriaRefCollection.getReferenceTargetElements((ModelElementInstance)this);
    }

    @Override
    public Collection<Sentry> getExitCriterias() {
        return exitCriteriaRefCollection.getReferenceTargetElements((ModelElementInstance)this);
    }

    @Override
    public Collection<Sentry> getEntryCriteria() {
        if (!this.isCmmn11()) {
            return Collections.unmodifiableCollection(this.getEntryCriterias());
        }
        ArrayList<Sentry> sentries = new ArrayList<Sentry>();
        Collection<EntryCriterion> entryCriterions = this.getEntryCriterions();
        for (EntryCriterion entryCriterion : entryCriterions) {
            Sentry sentry = entryCriterion.getSentry();
            if (sentry == null) continue;
            sentries.add(sentry);
        }
        return Collections.unmodifiableCollection(sentries);
    }

    @Override
    public Collection<Sentry> getExitCriteria() {
        if (!this.isCmmn11()) {
            return Collections.unmodifiableCollection(this.getExitCriterias());
        }
        ArrayList<Sentry> sentries = new ArrayList<Sentry>();
        Collection<ExitCriterion> exitCriterions = this.getExitCriterions();
        for (ExitCriterion exitCriterion : exitCriterions) {
            Sentry sentry = exitCriterion.getSentry();
            if (sentry == null) continue;
            sentries.add(sentry);
        }
        return Collections.unmodifiableCollection(sentries);
    }

    @Override
    public Collection<EntryCriterion> getEntryCriterions() {
        return entryCriterionCollection.get((ModelElementInstance)this);
    }

    @Override
    public Collection<ExitCriterion> getExitCriterions() {
        return exitCriterionCollection.get((ModelElementInstance)this);
    }

    @Override
    public ItemControl getItemControl() {
        return (ItemControl)itemControlChild.getChild((ModelElementInstance)this);
    }

    @Override
    public void setItemControl(ItemControl itemControl) {
        itemControlChild.setChild((ModelElementInstance)this, (ModelElementInstance)itemControl);
    }

    public static void registerType(ModelBuilder modelBuilder) {
        ModelElementTypeBuilder typeBuilder = modelBuilder.defineType(PlanItem.class, "planItem").namespaceUri("http://www.omg.org/spec/CMMN/20151109/MODEL").extendsType(CmmnElement.class).instanceProvider(PlanItemImpl::new);
        nameAttribute = typeBuilder.stringAttribute("name").build();
        planItemDefinitionRefAttribute = typeBuilder.stringAttribute("definitionRef").idAttributeReference(PlanItemDefinition.class).build();
        entryCriteriaRefCollection = typeBuilder.stringAttribute("entryCriteriaRefs").namespace("http://www.omg.org/spec/CMMN/20131201/MODEL").idAttributeReferenceCollection(Sentry.class, CmmnAttributeElementReferenceCollection.class).build();
        exitCriteriaRefCollection = typeBuilder.stringAttribute("exitCriteriaRefs").namespace("http://www.omg.org/spec/CMMN/20131201/MODEL").idAttributeReferenceCollection(Sentry.class, CmmnAttributeElementReferenceCollection.class).build();
        SequenceBuilder sequenceBuilder = typeBuilder.sequence();
        itemControlChild = sequenceBuilder.element(ItemControl.class).build();
        entryCriterionCollection = sequenceBuilder.elementCollection(EntryCriterion.class).build();
        exitCriterionCollection = sequenceBuilder.elementCollection(ExitCriterion.class).build();
        typeBuilder.build();
    }
}

