/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.variable;

import io.openbpm.bpm.engine.variable.VariableMap;
import io.openbpm.bpm.engine.variable.context.VariableContext;
import io.openbpm.bpm.engine.variable.impl.VariableMapImpl;
import io.openbpm.bpm.engine.variable.impl.context.EmptyVariableContext;
import io.openbpm.bpm.engine.variable.impl.value.AbstractTypedValue;
import io.openbpm.bpm.engine.variable.impl.value.FileValueImpl;
import io.openbpm.bpm.engine.variable.impl.value.NullValueImpl;
import io.openbpm.bpm.engine.variable.impl.value.PrimitiveTypeValueImpl;
import io.openbpm.bpm.engine.variable.impl.value.UntypedValueImpl;
import io.openbpm.bpm.engine.variable.impl.value.builder.FileValueBuilderImpl;
import io.openbpm.bpm.engine.variable.impl.value.builder.ObjectVariableBuilderImpl;
import io.openbpm.bpm.engine.variable.impl.value.builder.SerializedObjectValueBuilderImpl;
import io.openbpm.bpm.engine.variable.value.BooleanValue;
import io.openbpm.bpm.engine.variable.value.BytesValue;
import io.openbpm.bpm.engine.variable.value.DateValue;
import io.openbpm.bpm.engine.variable.value.DoubleValue;
import io.openbpm.bpm.engine.variable.value.FileValue;
import io.openbpm.bpm.engine.variable.value.IntegerValue;
import io.openbpm.bpm.engine.variable.value.LongValue;
import io.openbpm.bpm.engine.variable.value.NumberValue;
import io.openbpm.bpm.engine.variable.value.SerializationDataFormat;
import io.openbpm.bpm.engine.variable.value.ShortValue;
import io.openbpm.bpm.engine.variable.value.StringValue;
import io.openbpm.bpm.engine.variable.value.TypedValue;
import io.openbpm.bpm.engine.variable.value.builder.FileValueBuilder;
import io.openbpm.bpm.engine.variable.value.builder.ObjectValueBuilder;
import io.openbpm.bpm.engine.variable.value.builder.SerializedObjectValueBuilder;
import io.openbpm.bpm.engine.variable.value.builder.TypedValueBuilder;
import jakarta.activation.FileTypeMap;
import java.io.File;
import java.util.Date;
import java.util.Map;

public class Variables {
    public static VariableMap createVariables() {
        return new VariableMapImpl();
    }

    public static VariableMap fromMap(Map<String, Object> map) {
        if (map instanceof VariableMap) {
            VariableMap variableMap = (VariableMap)map;
            return variableMap;
        }
        return new VariableMapImpl(map);
    }

    public static VariableMap putValue(String name, Object value) {
        return Variables.createVariables().putValue(name, value);
    }

    public static VariableMap putValueTyped(String name, TypedValue value) {
        return Variables.createVariables().putValueTyped(name, value);
    }

    public static ObjectValueBuilder objectValue(Object value) {
        return new ObjectVariableBuilderImpl(value);
    }

    public static ObjectValueBuilder objectValue(Object value, boolean isTransient) {
        return (ObjectValueBuilder)Variables.objectValue(value).setTransient(isTransient);
    }

    public static SerializedObjectValueBuilder serializedObjectValue() {
        return new SerializedObjectValueBuilderImpl();
    }

    public static SerializedObjectValueBuilder serializedObjectValue(String value) {
        return Variables.serializedObjectValue().serializedValue(value);
    }

    public static SerializedObjectValueBuilder serializedObjectValue(String value, boolean isTransient) {
        return (SerializedObjectValueBuilder)Variables.serializedObjectValue().serializedValue(value).setTransient(isTransient);
    }

    public static IntegerValue integerValue(Integer integer) {
        return Variables.integerValue(integer, false);
    }

    public static IntegerValue integerValue(Integer integer, boolean isTransient) {
        return new PrimitiveTypeValueImpl.IntegerValueImpl(integer, isTransient);
    }

    public static StringValue stringValue(String stringValue) {
        return Variables.stringValue(stringValue, false);
    }

    public static StringValue stringValue(String stringValue, boolean isTransient) {
        return new PrimitiveTypeValueImpl.StringValueImpl(stringValue, isTransient);
    }

    public static BooleanValue booleanValue(Boolean booleanValue) {
        return Variables.booleanValue(booleanValue, false);
    }

    public static BooleanValue booleanValue(Boolean booleanValue, boolean isTransient) {
        return new PrimitiveTypeValueImpl.BooleanValueImpl(booleanValue, isTransient);
    }

    public static BytesValue byteArrayValue(byte[] bytes) {
        return Variables.byteArrayValue(bytes, false);
    }

    public static BytesValue byteArrayValue(byte[] bytes, boolean isTransient) {
        return new PrimitiveTypeValueImpl.BytesValueImpl(bytes, isTransient);
    }

    public static DateValue dateValue(Date date) {
        return Variables.dateValue(date, false);
    }

    public static DateValue dateValue(Date date, boolean isTransient) {
        return new PrimitiveTypeValueImpl.DateValueImpl(date, isTransient);
    }

    public static LongValue longValue(Long longValue) {
        return Variables.longValue(longValue, false);
    }

    public static LongValue longValue(Long longValue, boolean isTransient) {
        return new PrimitiveTypeValueImpl.LongValueImpl(longValue, isTransient);
    }

    public static ShortValue shortValue(Short shortValue) {
        return Variables.shortValue(shortValue, false);
    }

    public static ShortValue shortValue(Short shortValue, boolean isTransient) {
        return new PrimitiveTypeValueImpl.ShortValueImpl(shortValue, isTransient);
    }

    public static DoubleValue doubleValue(Double doubleValue) {
        return Variables.doubleValue(doubleValue, false);
    }

    public static DoubleValue doubleValue(Double doubleValue, boolean isTransient) {
        return new PrimitiveTypeValueImpl.DoubleValueImpl(doubleValue, isTransient);
    }

    public static NumberValue numberValue(Number numberValue) {
        return Variables.numberValue(numberValue, false);
    }

    public static NumberValue numberValue(Number numberValue, boolean isTransient) {
        return new PrimitiveTypeValueImpl.NumberValueImpl(numberValue, isTransient);
    }

    public static TypedValue untypedNullValue() {
        return Variables.untypedNullValue(false);
    }

    public static TypedValue untypedNullValue(boolean isTransient) {
        if (isTransient) {
            return NullValueImpl.INSTANCE_TRANSIENT;
        }
        return NullValueImpl.INSTANCE;
    }

    public static TypedValue untypedValue(Object value) {
        Object untypedValue = value;
        if (untypedValue instanceof TypedValueBuilder) {
            TypedValueBuilder builder = (TypedValueBuilder)untypedValue;
            untypedValue = builder.create();
        }
        if (untypedValue instanceof TypedValue) {
            TypedValue typedvalue = (TypedValue)untypedValue;
            return Variables.untypedValue(typedvalue, typedvalue.isTransient());
        }
        return Variables.untypedValue(untypedValue, false);
    }

    public static TypedValue untypedValue(Object value, boolean isTransient) {
        if (value == null) {
            return Variables.untypedNullValue(isTransient);
        }
        if (value instanceof TypedValueBuilder) {
            TypedValueBuilder builder = (TypedValueBuilder)value;
            return builder.setTransient(isTransient).create();
        }
        if (value instanceof TypedValue) {
            TypedValue transientValue = (TypedValue)value;
            if (value instanceof NullValueImpl) {
                transientValue = Variables.untypedNullValue(isTransient);
            } else if (value instanceof FileValue) {
                ((FileValueImpl)transientValue).setTransient(isTransient);
            } else if (value instanceof AbstractTypedValue) {
                ((AbstractTypedValue)transientValue).setTransient(isTransient);
            }
            return transientValue;
        }
        return new UntypedValueImpl(value, isTransient);
    }

    public static FileValueBuilder fileValue(String filename) {
        return Variables.fileValue(filename, false);
    }

    public static FileValueBuilder fileValue(String filename, boolean isTransient) {
        return new FileValueBuilderImpl(filename).setTransient(isTransient);
    }

    public static FileValue fileValue(File file) {
        String contentType = FileTypeMap.getDefaultFileTypeMap().getContentType(file);
        return (FileValue)new FileValueBuilderImpl(file.getName()).file(file).mimeType(contentType).create();
    }

    public static FileValue fileValue(File file, boolean isTransient) {
        String contentType = FileTypeMap.getDefaultFileTypeMap().getContentType(file);
        return (FileValue)new FileValueBuilderImpl(file.getName()).file(file).mimeType(contentType).setTransient(isTransient).create();
    }

    public static VariableContext emptyVariableContext() {
        return EmptyVariableContext.INSTANCE;
    }

    public static enum SerializationDataFormats implements SerializationDataFormat
    {
        JAVA("application/x-java-serialized-object"),
        JSON("application/json"),
        XML("application/xml");

        private final String name;

        private SerializationDataFormats(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

