/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.variable.impl.context;

import io.openbpm.bpm.engine.variable.context.VariableContext;
import io.openbpm.bpm.engine.variable.value.TypedValue;
import java.util.HashSet;
import java.util.Set;

public class CompositeVariableContext
implements VariableContext {
    protected final VariableContext[] delegateContexts;

    public CompositeVariableContext(VariableContext[] delegateContexts) {
        this.delegateContexts = delegateContexts;
    }

    @Override
    public TypedValue resolve(String variableName) {
        for (VariableContext variableContext : this.delegateContexts) {
            TypedValue resolvedValue = variableContext.resolve(variableName);
            if (resolvedValue == null) continue;
            return resolvedValue;
        }
        return null;
    }

    @Override
    public boolean containsVariable(String name) {
        for (VariableContext variableContext : this.delegateContexts) {
            if (!variableContext.containsVariable(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keySet = new HashSet<String>();
        for (VariableContext variableContext : this.delegateContexts) {
            keySet.addAll(variableContext.keySet());
        }
        return keySet;
    }

    public static CompositeVariableContext compose(VariableContext ... variableContexts) {
        return new CompositeVariableContext(variableContexts);
    }
}

