/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.dto.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.history.HistoricIncidentQuery;
import io.openbpm.bpm.engine.rest.dto.AbstractQueryDto;
import io.openbpm.bpm.engine.rest.dto.OperatonQueryParam;
import io.openbpm.bpm.engine.rest.dto.converter.BooleanConverter;
import io.openbpm.bpm.engine.rest.dto.converter.DateConverter;
import io.openbpm.bpm.engine.rest.dto.converter.StringArrayConverter;
import io.openbpm.bpm.engine.rest.dto.converter.StringListConverter;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class HistoricIncidentQueryDto
extends AbstractQueryDto<HistoricIncidentQuery> {
    private static final String SORT_BY_INCIDENT_ID = "incidentId";
    private static final String SORT_BY_INCIDENT_MESSAGE = "incidentMessage";
    private static final String SORT_BY_CREATE_TIME = "createTime";
    private static final String SORT_BY_END_TIME = "endTime";
    private static final String SORT_BY_INCIDENT_TYPE = "incidentType";
    private static final String SORT_BY_EXECUTION_ID = "executionId";
    private static final String SORT_BY_ACTIVITY_ID = "activityId";
    private static final String SORT_BY_PROCESS_INSTANCE_ID = "processInstanceId";
    private static final String SORT_BY_PROCESS_DEFINITION_ID = "processDefinitionId";
    private static final String SORT_BY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    private static final String SORT_BY_CAUSE_INCIDENT_ID = "causeIncidentId";
    private static final String SORT_BY_ROOT_CAUSE_INCIDENT_ID = "rootCauseIncidentId";
    private static final String SORT_BY_CONFIGURATION = "configuration";
    private static final String SORT_BY_HISTORY_CONFIGURATION = "historyConfiguration";
    private static final String SORT_BY_TENANT_ID = "tenantId";
    private static final String SORT_BY_INCIDENT_STATE = "incidentState";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    protected String incidentId;
    protected String incidentType;
    protected String incidentMessage;
    protected String incidentMessageLike;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String[] processDefinitionKeyIn;
    protected String processInstanceId;
    protected String executionId;
    protected Date createTimeBefore;
    protected Date createTimeAfter;
    protected Date endTimeBefore;
    protected Date endTimeAfter;
    protected String activityId;
    protected String failedActivityId;
    protected String causeIncidentId;
    protected String rootCauseIncidentId;
    protected String configuration;
    protected String historyConfiguration;
    protected Boolean open;
    protected Boolean resolved;
    protected Boolean deleted;
    protected List<String> tenantIds;
    protected Boolean withoutTenantId;
    protected List<String> jobDefinitionIds;

    public HistoricIncidentQueryDto() {
    }

    public HistoricIncidentQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @OperatonQueryParam(value="incidentId")
    public void setIncidentId(String incidentId) {
        this.incidentId = incidentId;
    }

    @OperatonQueryParam(value="incidentType")
    public void setIncidentType(String incidentType) {
        this.incidentType = incidentType;
    }

    @OperatonQueryParam(value="incidentMessage")
    public void setIncidentMessage(String incidentMessage) {
        this.incidentMessage = incidentMessage;
    }

    @OperatonQueryParam(value="incidentMessageLike")
    public void setIncidentMessageLike(String incidentMessageLike) {
        this.incidentMessageLike = incidentMessageLike;
    }

    @OperatonQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @OperatonQueryParam(value="processDefinitionKey")
    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @OperatonQueryParam(value="processDefinitionKeyIn", converter=StringArrayConverter.class)
    public void setProcessDefinitionKeyIn(String[] processDefinitionKeyIn) {
        this.processDefinitionKeyIn = processDefinitionKeyIn;
    }

    @OperatonQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @OperatonQueryParam(value="executionId")
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @OperatonQueryParam(value="createTimeBefore", converter=DateConverter.class)
    public void setCreateTimeBefore(Date createTimeBefore) {
        this.createTimeBefore = createTimeBefore;
    }

    @OperatonQueryParam(value="createTimeAfter", converter=DateConverter.class)
    public void setCreateTimeAfter(Date createTimeAfter) {
        this.createTimeAfter = createTimeAfter;
    }

    @OperatonQueryParam(value="endTimeBefore", converter=DateConverter.class)
    public void setEndTimeBefore(Date endTimeBefore) {
        this.endTimeBefore = endTimeBefore;
    }

    @OperatonQueryParam(value="endTimeAfter", converter=DateConverter.class)
    public void setEndTimeAfter(Date endTimeAfter) {
        this.endTimeAfter = endTimeAfter;
    }

    @OperatonQueryParam(value="activityId")
    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    @OperatonQueryParam(value="failedActivityId")
    public void setFailedActivityId(String activityId) {
        this.failedActivityId = activityId;
    }

    @OperatonQueryParam(value="causeIncidentId")
    public void setCauseIncidentId(String causeIncidentId) {
        this.causeIncidentId = causeIncidentId;
    }

    @OperatonQueryParam(value="rootCauseIncidentId")
    public void setRootCauseIncidentId(String rootCauseIncidentId) {
        this.rootCauseIncidentId = rootCauseIncidentId;
    }

    @OperatonQueryParam(value="configuration")
    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    @OperatonQueryParam(value="historyConfiguration")
    public void setHistoryConfiguration(String historyConfiguration) {
        this.historyConfiguration = historyConfiguration;
    }

    @OperatonQueryParam(value="open", converter=BooleanConverter.class)
    public void setOpen(Boolean open) {
        this.open = open;
    }

    @OperatonQueryParam(value="resolved", converter=BooleanConverter.class)
    public void setResolved(Boolean resolved) {
        this.resolved = resolved;
    }

    @OperatonQueryParam(value="deleted", converter=BooleanConverter.class)
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @OperatonQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @OperatonQueryParam(value="withoutTenantId", converter=BooleanConverter.class)
    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    @OperatonQueryParam(value="jobDefinitionIdIn", converter=StringListConverter.class)
    public void setJobDefinitionIdIn(List<String> jobDefinitionIds) {
        this.jobDefinitionIds = jobDefinitionIds;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected HistoricIncidentQuery createNewQuery(ProcessEngine engine) {
        return engine.getHistoryService().createHistoricIncidentQuery();
    }

    @Override
    protected void applyFilters(HistoricIncidentQuery query) {
        if (this.incidentId != null) {
            query.incidentId(this.incidentId);
        }
        if (this.incidentType != null) {
            query.incidentType(this.incidentType);
        }
        if (this.incidentMessage != null) {
            query.incidentMessage(this.incidentMessage);
        }
        if (this.incidentMessageLike != null) {
            query.incidentMessageLike(this.incidentMessageLike);
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.processDefinitionKey != null) {
            query.processDefinitionKey(this.processDefinitionKey);
        }
        if (this.processDefinitionKeyIn != null && this.processDefinitionKeyIn.length > 0) {
            query.processDefinitionKeyIn(this.processDefinitionKeyIn);
        }
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (this.executionId != null) {
            query.executionId(this.executionId);
        }
        if (this.createTimeBefore != null) {
            query.createTimeBefore(this.createTimeBefore);
        }
        if (this.createTimeAfter != null) {
            query.createTimeAfter(this.createTimeAfter);
        }
        if (this.endTimeBefore != null) {
            query.endTimeBefore(this.endTimeBefore);
        }
        if (this.endTimeAfter != null) {
            query.endTimeAfter(this.endTimeAfter);
        }
        if (this.activityId != null) {
            query.activityId(this.activityId);
        }
        if (this.failedActivityId != null) {
            query.failedActivityId(this.failedActivityId);
        }
        if (this.causeIncidentId != null) {
            query.causeIncidentId(this.causeIncidentId);
        }
        if (this.rootCauseIncidentId != null) {
            query.rootCauseIncidentId(this.rootCauseIncidentId);
        }
        if (this.configuration != null) {
            query.configuration(this.configuration);
        }
        if (this.historyConfiguration != null) {
            query.historyConfiguration(this.historyConfiguration);
        }
        if (this.open != null) {
            query.open();
        }
        if (this.resolved != null && this.resolved.booleanValue()) {
            query.resolved();
        }
        if (this.deleted != null && this.deleted.booleanValue()) {
            query.deleted();
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[this.tenantIds.size()]));
        }
        if (Boolean.TRUE.equals(this.withoutTenantId)) {
            query.withoutTenantId();
        }
        if (this.jobDefinitionIds != null && !this.jobDefinitionIds.isEmpty()) {
            query.jobDefinitionIdIn(this.jobDefinitionIds.toArray(new String[this.jobDefinitionIds.size()]));
        }
    }

    @Override
    protected void applySortBy(HistoricIncidentQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (SORT_BY_INCIDENT_ID.equals(sortBy)) {
            query.orderByIncidentId();
        } else if (SORT_BY_INCIDENT_MESSAGE.equals(sortBy)) {
            query.orderByIncidentMessage();
        } else if (SORT_BY_CREATE_TIME.equals(sortBy)) {
            query.orderByCreateTime();
        } else if (SORT_BY_END_TIME.equals(sortBy)) {
            query.orderByEndTime();
        } else if (SORT_BY_INCIDENT_TYPE.equals(sortBy)) {
            query.orderByIncidentType();
        } else if (SORT_BY_EXECUTION_ID.equals(sortBy)) {
            query.orderByExecutionId();
        } else if (SORT_BY_ACTIVITY_ID.equals(sortBy)) {
            query.orderByActivityId();
        } else if (SORT_BY_PROCESS_INSTANCE_ID.equals(sortBy)) {
            query.orderByProcessInstanceId();
        } else if (SORT_BY_PROCESS_DEFINITION_KEY.equals(sortBy)) {
            query.orderByProcessDefinitionKey();
        } else if (SORT_BY_PROCESS_DEFINITION_ID.equals(sortBy)) {
            query.orderByProcessDefinitionId();
        } else if (SORT_BY_CAUSE_INCIDENT_ID.equals(sortBy)) {
            query.orderByCauseIncidentId();
        } else if (SORT_BY_ROOT_CAUSE_INCIDENT_ID.equals(sortBy)) {
            query.orderByRootCauseIncidentId();
        } else if (SORT_BY_CONFIGURATION.equals(sortBy)) {
            query.orderByConfiguration();
        } else if (SORT_BY_HISTORY_CONFIGURATION.equals(sortBy)) {
            query.orderByHistoryConfiguration();
        } else if (SORT_BY_TENANT_ID.equals(sortBy)) {
            query.orderByTenantId();
        } else if (SORT_BY_INCIDENT_STATE.equals(sortBy)) {
            query.orderByIncidentState();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_INCIDENT_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_INCIDENT_MESSAGE);
        VALID_SORT_BY_VALUES.add(SORT_BY_CREATE_TIME);
        VALID_SORT_BY_VALUES.add(SORT_BY_END_TIME);
        VALID_SORT_BY_VALUES.add(SORT_BY_INCIDENT_TYPE);
        VALID_SORT_BY_VALUES.add(SORT_BY_EXECUTION_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_ACTIVITY_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_KEY);
        VALID_SORT_BY_VALUES.add(SORT_BY_CAUSE_INCIDENT_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_ROOT_CAUSE_INCIDENT_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_CONFIGURATION);
        VALID_SORT_BY_VALUES.add(SORT_BY_HISTORY_CONFIGURATION);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_INCIDENT_STATE);
    }
}

