/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.dto.history.batch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.batch.history.HistoricBatchQuery;
import io.openbpm.bpm.engine.rest.dto.AbstractQueryDto;
import io.openbpm.bpm.engine.rest.dto.OperatonQueryParam;
import io.openbpm.bpm.engine.rest.dto.converter.BooleanConverter;
import io.openbpm.bpm.engine.rest.dto.converter.StringListConverter;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HistoricBatchQueryDto
extends AbstractQueryDto<HistoricBatchQuery> {
    private static final String SORT_BY_BATCH_ID_VALUE = "batchId";
    private static final String SORT_BY_BATCH_START_TIME_VALUE = "startTime";
    private static final String SORT_BY_BATCH_END_TIME_VALUE = "endTime";
    private static final String SORT_BY_TENANT_ID_VALUE = "tenantId";
    protected String batchId;
    protected String type;
    protected Boolean completed;
    protected List<String> tenantIds;
    protected Boolean withoutTenantId;
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();

    public HistoricBatchQueryDto() {
    }

    public HistoricBatchQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @OperatonQueryParam(value="batchId")
    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    @OperatonQueryParam(value="type")
    public void setType(String type) {
        this.type = type;
    }

    @OperatonQueryParam(value="completed", converter=BooleanConverter.class)
    public void setCompleted(Boolean completed) {
        this.completed = completed;
    }

    @OperatonQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @OperatonQueryParam(value="withoutTenantId", converter=BooleanConverter.class)
    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected HistoricBatchQuery createNewQuery(ProcessEngine engine) {
        return engine.getHistoryService().createHistoricBatchQuery();
    }

    @Override
    protected void applyFilters(HistoricBatchQuery query) {
        if (this.batchId != null) {
            query.batchId(this.batchId);
        }
        if (this.type != null) {
            query.type(this.type);
        }
        if (this.completed != null) {
            query.completed(this.completed.booleanValue());
        }
        if (Boolean.TRUE.equals(this.withoutTenantId)) {
            query.withoutTenantId();
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[this.tenantIds.size()]));
        }
    }

    @Override
    protected void applySortBy(HistoricBatchQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (SORT_BY_BATCH_ID_VALUE.equals(sortBy)) {
            query.orderById();
        }
        if (SORT_BY_BATCH_START_TIME_VALUE.equals(sortBy)) {
            query.orderByStartTime();
        }
        if (SORT_BY_BATCH_END_TIME_VALUE.equals(sortBy)) {
            query.orderByEndTime();
        }
        if (SORT_BY_TENANT_ID_VALUE.equals(sortBy)) {
            query.orderByTenantId();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_BATCH_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_BATCH_START_TIME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_BATCH_END_TIME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID_VALUE);
    }
}

