/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.dto.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.rest.dto.AbstractQueryDto;
import io.openbpm.bpm.engine.rest.dto.OperatonQueryParam;
import io.openbpm.bpm.engine.rest.dto.converter.BooleanConverter;
import io.openbpm.bpm.engine.rest.dto.converter.StringListConverter;
import io.openbpm.bpm.engine.runtime.EventSubscriptionQuery;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EventSubscriptionQueryDto
extends AbstractQueryDto<EventSubscriptionQuery> {
    private static final String SORT_BY_TENANT_ID = "tenantId";
    private static final String SORT_BY_CREATED = "created";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    private String eventSubscriptionId;
    private String eventName;
    private String eventType;
    private String executionId;
    private String processInstanceId;
    private String activityId;
    private List<String> tenantIdIn;
    private Boolean withoutTenantId;
    private Boolean includeEventSubscriptionsWithoutTenantId;

    public EventSubscriptionQueryDto() {
    }

    public EventSubscriptionQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    public String getEventSubscriptionId() {
        return this.eventSubscriptionId;
    }

    @OperatonQueryParam(value="eventSubscriptionId")
    public void setEventSubscriptionId(String eventSubscriptionId) {
        this.eventSubscriptionId = eventSubscriptionId;
    }

    public String getEventName() {
        return this.eventName;
    }

    @OperatonQueryParam(value="eventName")
    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public String getEventType() {
        return this.eventType;
    }

    @OperatonQueryParam(value="eventType")
    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    @OperatonQueryParam(value="executionId")
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @OperatonQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    @OperatonQueryParam(value="activityId")
    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public List<String> getTenantIdIn() {
        return this.tenantIdIn;
    }

    @OperatonQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
    }

    public Boolean getWithoutTenantId() {
        return this.withoutTenantId;
    }

    @OperatonQueryParam(value="withoutTenantId", converter=BooleanConverter.class)
    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    public Boolean getIncludeEventSubscriptionsWithoutTenantId() {
        return this.includeEventSubscriptionsWithoutTenantId;
    }

    @OperatonQueryParam(value="includeEventSubscriptionsWithoutTenantId", converter=BooleanConverter.class)
    public void setIncludeEventSubscriptionsWithoutTenantId(Boolean includeEventSubscriptionsWithoutTenantId) {
        this.includeEventSubscriptionsWithoutTenantId = includeEventSubscriptionsWithoutTenantId;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected EventSubscriptionQuery createNewQuery(ProcessEngine engine) {
        return engine.getRuntimeService().createEventSubscriptionQuery();
    }

    @Override
    protected void applyFilters(EventSubscriptionQuery query) {
        if (this.eventSubscriptionId != null) {
            query.eventSubscriptionId(this.eventSubscriptionId);
        }
        if (this.eventName != null) {
            query.eventName(this.eventName);
        }
        if (this.eventType != null) {
            query.eventType(this.eventType);
        }
        if (this.executionId != null) {
            query.executionId(this.executionId);
        }
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (this.activityId != null) {
            query.activityId(this.activityId);
        }
        if (this.tenantIdIn != null && !this.tenantIdIn.isEmpty()) {
            query.tenantIdIn(this.tenantIdIn.toArray(new String[this.tenantIdIn.size()]));
        }
        if (Boolean.TRUE.equals(this.withoutTenantId)) {
            query.withoutTenantId();
        }
        if (Boolean.TRUE.equals(this.includeEventSubscriptionsWithoutTenantId)) {
            query.includeEventSubscriptionsWithoutTenantId();
        }
    }

    @Override
    protected void applySortBy(EventSubscriptionQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (SORT_BY_CREATED.equals(sortBy)) {
            query.orderByCreated();
        } else if (SORT_BY_TENANT_ID.equals(sortBy)) {
            query.orderByTenantId();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_CREATED);
    }
}

