/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.hal;

import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.rest.hal.Hal;
import io.openbpm.bpm.engine.rest.hal.HalLink;
import io.openbpm.bpm.engine.rest.hal.HalLinker;
import io.openbpm.bpm.engine.rest.hal.HalRelation;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class HalResource<T extends HalResource<?>> {
    protected Map<String, HalLink> links;
    protected Map<String, Object> embedded;
    protected HalLinker linker = Hal.getInstance().createLinker(this);

    protected HalResource() {
    }

    public Map<String, HalLink> getLinks() {
        return this.links;
    }

    @Deprecated(forRemoval=true, since="1.0")
    public Map<String, HalLink> get_links() {
        return this.links;
    }

    public Map<String, Object> getEmbedded() {
        return this.embedded;
    }

    @Deprecated(forRemoval=true, since="1.0")
    public Map<String, Object> get_embedded() {
        return this.embedded;
    }

    public void addLink(String rel, String href) {
        if (this.links == null) {
            this.links = new TreeMap<String, HalLink>();
        }
        this.links.put(rel, new HalLink(href));
    }

    public void addLink(String rel, URI hrefUri) {
        this.addLink(rel, hrefUri.toString());
    }

    public void addEmbedded(String name, HalResource<?> embedded) {
        this.linker.mergeLinks(embedded);
        this.addEmbeddedObject(name, embedded);
    }

    private void addEmbeddedObject(String name, Object embedded) {
        if (this.embedded == null) {
            this.embedded = new TreeMap<String, Object>();
        }
        this.embedded.put(name, embedded);
    }

    public void addEmbedded(String name, List<HalResource<?>> embeddedCollection) {
        for (HalResource<?> resource : embeddedCollection) {
            this.linker.mergeLinks(resource);
        }
        this.addEmbeddedObject(name, embeddedCollection);
    }

    public Object getEmbedded(String name) {
        return this.embedded.get(name);
    }

    public T embed(HalRelation relation, ProcessEngine processEngine) {
        List<HalResource<?>> resolvedLinks = this.linker.resolve(relation, processEngine);
        if (resolvedLinks != null && !resolvedLinks.isEmpty()) {
            this.addEmbedded(relation.relName, resolvedLinks);
        }
        return (T)this;
    }
}

