/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.hal.cache;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.rest.cache.Cache;
import io.openbpm.bpm.engine.rest.hal.cache.HalRelationCacheConfigurationException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class HalRelationCacheConfiguration {
    public static final String CONFIG_CACHE_IMPLEMENTATION = "cacheImplementation";
    public static final String CONFIG_CACHES = "caches";
    protected ObjectMapper objectMapper = new ObjectMapper();
    protected Class<? extends Cache> cacheImplementationClass;
    protected Map<Class<?>, Map<String, Object>> cacheConfigurations = new HashMap();

    public HalRelationCacheConfiguration() {
    }

    public HalRelationCacheConfiguration(String configuration) {
        this();
        this.parseConfiguration(configuration);
    }

    public Class<? extends Cache> getCacheImplementationClass() {
        return this.cacheImplementationClass;
    }

    public void setCacheImplementationClass(Class<?> cacheImplementationClass) {
        if (!Cache.class.isAssignableFrom(cacheImplementationClass)) {
            throw new HalRelationCacheConfigurationException("Cache implementation class " + cacheImplementationClass.getName() + " does not implement the interface " + Cache.class.getName());
        }
        this.cacheImplementationClass = cacheImplementationClass;
    }

    public Map<Class<?>, Map<String, Object>> getCacheConfigurations() {
        return this.cacheConfigurations;
    }

    public void setCacheConfigurations(Map<Class<?>, Map<String, Object>> cacheConfigurations) {
        this.cacheConfigurations = cacheConfigurations;
    }

    public void addCacheConfiguration(Class<?> halResourceClass, Map<String, Object> cacheConfiguration) {
        this.cacheConfigurations.put(halResourceClass, cacheConfiguration);
    }

    protected void parseConfiguration(String configuration) {
        try {
            JsonNode jsonConfiguration = this.objectMapper.readTree(configuration);
            this.parseConfiguration(jsonConfiguration);
        }
        catch (IOException e) {
            throw new HalRelationCacheConfigurationException("Unable to parse cache configuration", e);
        }
    }

    protected void parseConfiguration(JsonNode jsonConfiguration) {
        this.parseCacheImplementationClass(jsonConfiguration);
        this.parseCacheConfigurations(jsonConfiguration);
    }

    protected void parseCacheImplementationClass(JsonNode jsonConfiguration) {
        JsonNode jsonNode = jsonConfiguration.get(CONFIG_CACHE_IMPLEMENTATION);
        if (jsonNode == null) {
            throw new HalRelationCacheConfigurationException("Unable to find the cacheImplementation parameter");
        }
        String cacheImplementationClassName = jsonNode.textValue();
        Class<?> cacheImplClass = this.loadClass(cacheImplementationClassName);
        this.setCacheImplementationClass(cacheImplClass);
    }

    protected void parseCacheConfigurations(JsonNode jsonConfiguration) {
        JsonNode jsonNode = jsonConfiguration.get(CONFIG_CACHES);
        if (jsonNode != null) {
            Iterator cacheConfigs = jsonNode.fields();
            while (cacheConfigs.hasNext()) {
                Map.Entry cacheConfiguration = (Map.Entry)cacheConfigs.next();
                this.parseCacheConfiguration((String)cacheConfiguration.getKey(), (JsonNode)cacheConfiguration.getValue());
            }
        }
    }

    protected void parseCacheConfiguration(String halResourceClassName, JsonNode jsonConfiguration) {
        try {
            Class<?> halResourceClass = this.loadClass(halResourceClassName);
            Map configuration = (Map)this.objectMapper.treeToValue((TreeNode)jsonConfiguration, Map.class);
            this.addCacheConfiguration(halResourceClass, configuration);
        }
        catch (IOException e) {
            throw new HalRelationCacheConfigurationException("Unable to parse cache configuration for HAL resource " + halResourceClassName);
        }
    }

    protected Class<?> loadClass(String className) {
        try {
            return Class.forName(className, true, HalRelationCacheConfiguration.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new HalRelationCacheConfigurationException("Unable to load class of cache configuration " + className, e);
        }
    }
}

