/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.hal.processDefinition;

import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.repository.ProcessDefinition;
import io.openbpm.bpm.engine.rest.DeploymentRestService;
import io.openbpm.bpm.engine.rest.ProcessDefinitionRestService;
import io.openbpm.bpm.engine.rest.hal.HalIdResource;
import io.openbpm.bpm.engine.rest.hal.HalRelation;
import io.openbpm.bpm.engine.rest.hal.HalResource;
import io.openbpm.bpm.engine.rest.sub.repository.DeploymentResourcesResource;
import io.openbpm.bpm.engine.rest.util.ApplicationContextPathUtil;
import jakarta.ws.rs.core.UriBuilder;

public class HalProcessDefinition
extends HalResource<HalProcessDefinition>
implements HalIdResource {
    public static final HalRelation REL_SELF = HalRelation.build("self", ProcessDefinitionRestService.class, UriBuilder.fromPath((String)"/process-definition").path("{id}"));
    public static final HalRelation REL_DEPLOYMENT = HalRelation.build("deployment", DeploymentRestService.class, UriBuilder.fromPath((String)"/deployment").path("{id}"));
    public static final HalRelation REL_DEPLOYMENT_RESOURCE = HalRelation.build("resource", DeploymentResourcesResource.class, UriBuilder.fromPath((String)"/deployment").path("{deploymentId}").path("resources").path("{resourceId}"));
    protected String id;
    protected String key;
    protected String category;
    protected String description;
    protected String name;
    protected String versionTag;
    protected int version;
    protected String resource;
    protected String deploymentId;
    protected String diagram;
    protected boolean suspended;
    protected String contextPath;

    public static HalProcessDefinition fromProcessDefinition(ProcessDefinition processDefinition, ProcessEngine processEngine) {
        HalProcessDefinition halProcDef = new HalProcessDefinition();
        halProcDef.id = processDefinition.getId();
        halProcDef.key = processDefinition.getKey();
        halProcDef.category = processDefinition.getCategory();
        halProcDef.description = processDefinition.getDescription();
        halProcDef.name = processDefinition.getName();
        halProcDef.version = processDefinition.getVersion();
        halProcDef.versionTag = processDefinition.getVersionTag();
        halProcDef.resource = processDefinition.getResourceName();
        halProcDef.deploymentId = processDefinition.getDeploymentId();
        halProcDef.diagram = processDefinition.getDiagramResourceName();
        halProcDef.suspended = processDefinition.isSuspended();
        halProcDef.contextPath = ApplicationContextPathUtil.getApplicationPathForDeployment(processEngine, processDefinition.getDeploymentId());
        halProcDef.linker.createLink(REL_SELF, processDefinition.getId());
        halProcDef.linker.createLink(REL_DEPLOYMENT, processDefinition.getDeploymentId());
        halProcDef.linker.createLink(REL_DEPLOYMENT_RESOURCE, processDefinition.getDeploymentId(), processDefinition.getResourceName());
        return halProcDef;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public String getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public int getVersion() {
        return this.version;
    }

    public String getVersionTag() {
        return this.versionTag;
    }

    public String getResource() {
        return this.resource;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public String getDiagram() {
        return this.diagram;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public String getContextPath() {
        return this.contextPath;
    }
}

