/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.ExternalTaskService;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.batch.Batch;
import io.openbpm.bpm.engine.exception.NotFoundException;
import io.openbpm.bpm.engine.externaltask.ExternalTask;
import io.openbpm.bpm.engine.externaltask.ExternalTaskQuery;
import io.openbpm.bpm.engine.externaltask.UpdateExternalTaskRetriesBuilder;
import io.openbpm.bpm.engine.history.HistoricProcessInstanceQuery;
import io.openbpm.bpm.engine.rest.ExternalTaskRestService;
import io.openbpm.bpm.engine.rest.dto.CountResultDto;
import io.openbpm.bpm.engine.rest.dto.batch.BatchDto;
import io.openbpm.bpm.engine.rest.dto.externaltask.ExternalTaskDto;
import io.openbpm.bpm.engine.rest.dto.externaltask.ExternalTaskQueryDto;
import io.openbpm.bpm.engine.rest.dto.externaltask.FetchExternalTasksExtendedDto;
import io.openbpm.bpm.engine.rest.dto.externaltask.SetRetriesForExternalTasksDto;
import io.openbpm.bpm.engine.rest.dto.history.HistoricProcessInstanceQueryDto;
import io.openbpm.bpm.engine.rest.dto.runtime.ProcessInstanceQueryDto;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import io.openbpm.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import io.openbpm.bpm.engine.rest.impl.FetchAndLockContextListener;
import io.openbpm.bpm.engine.rest.spi.FetchAndLockHandler;
import io.openbpm.bpm.engine.rest.sub.externaltask.ExternalTaskResource;
import io.openbpm.bpm.engine.rest.sub.externaltask.impl.ExternalTaskResourceImpl;
import io.openbpm.bpm.engine.rest.util.QueryUtil;
import io.openbpm.bpm.engine.runtime.ProcessInstanceQuery;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.List;

public class ExternalTaskRestServiceImpl
extends AbstractRestProcessEngineAware
implements ExternalTaskRestService {
    public ExternalTaskRestServiceImpl(String processEngine, ObjectMapper objectMapper) {
        super(processEngine, objectMapper);
    }

    @Override
    public List<ExternalTaskDto> getExternalTasks(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        ExternalTaskQueryDto queryDto = new ExternalTaskQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryExternalTasks(queryDto, firstResult, maxResults);
    }

    @Override
    public List<ExternalTaskDto> queryExternalTasks(ExternalTaskQueryDto queryDto, Integer firstResult, Integer maxResults) {
        ProcessEngine engine = this.getProcessEngine();
        queryDto.setObjectMapper(this.getObjectMapper());
        ExternalTaskQuery query = (ExternalTaskQuery)queryDto.toQuery(engine);
        List<ExternalTask> matchingTasks = QueryUtil.list(query, firstResult, maxResults);
        ArrayList<ExternalTaskDto> taskResults = new ArrayList<ExternalTaskDto>();
        for (ExternalTask task : matchingTasks) {
            ExternalTaskDto resultInstance = ExternalTaskDto.fromExternalTask(task);
            taskResults.add(resultInstance);
        }
        return taskResults;
    }

    @Override
    public CountResultDto getExternalTasksCount(UriInfo uriInfo) {
        ExternalTaskQueryDto queryDto = new ExternalTaskQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryExternalTasksCount(queryDto);
    }

    @Override
    public CountResultDto queryExternalTasksCount(ExternalTaskQueryDto queryDto) {
        ProcessEngine engine = this.getProcessEngine();
        queryDto.setObjectMapper(this.getObjectMapper());
        ExternalTaskQuery query = (ExternalTaskQuery)queryDto.toQuery(engine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }

    @Override
    public void fetchAndLock(FetchExternalTasksExtendedDto dto, AsyncResponse asyncResponse) {
        FetchAndLockHandler fetchAndLockHandler = FetchAndLockContextListener.getFetchAndLockHandler();
        fetchAndLockHandler.addPendingRequest(dto, asyncResponse, this.getProcessEngine());
    }

    @Override
    public ExternalTaskResource getExternalTask(String externalTaskId) {
        return new ExternalTaskResourceImpl(this.getProcessEngine(), externalTaskId, this.getObjectMapper());
    }

    @Override
    public BatchDto setRetriesAsync(SetRetriesForExternalTasksDto retriesDto) {
        UpdateExternalTaskRetriesBuilder builder = this.updateRetries(retriesDto);
        Integer retries = retriesDto.getRetries();
        if (retries == null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "The number of retries cannot be null.");
        }
        try {
            Batch batch = builder.setAsync(retries.intValue());
            return BatchDto.fromBatch(batch);
        }
        catch (NotFoundException e) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, e.getMessage());
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    @Override
    public List<String> getTopicNames(boolean withLockedTasks, boolean withUnlockedTasks, boolean withRetriesLeft) {
        return this.getProcessEngine().getExternalTaskService().getTopicNames(withLockedTasks, withUnlockedTasks, withRetriesLeft);
    }

    @Override
    public void setRetries(SetRetriesForExternalTasksDto retriesDto) {
        UpdateExternalTaskRetriesBuilder builder = this.updateRetries(retriesDto);
        Integer retries = retriesDto.getRetries();
        if (retries == null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "The number of retries cannot be null.");
        }
        try {
            builder.set(retries.intValue());
        }
        catch (NotFoundException e) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, e.getMessage());
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    protected UpdateExternalTaskRetriesBuilder updateRetries(SetRetriesForExternalTasksDto retriesDto) {
        HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto;
        ProcessInstanceQueryDto processInstanceQueryDto;
        ExternalTaskService externalTaskService = this.getProcessEngine().getExternalTaskService();
        List<String> externalTaskIds = retriesDto.getExternalTaskIds();
        List<String> processInstanceIds = retriesDto.getProcessInstanceIds();
        ExternalTaskQuery externalTaskQuery = null;
        ProcessInstanceQuery processInstanceQuery = null;
        HistoricProcessInstanceQuery historicProcessInstanceQuery = null;
        ExternalTaskQueryDto externalTaskQueryDto = retriesDto.getExternalTaskQuery();
        if (externalTaskQueryDto != null) {
            externalTaskQuery = (ExternalTaskQuery)externalTaskQueryDto.toQuery(this.getProcessEngine());
        }
        if ((processInstanceQueryDto = retriesDto.getProcessInstanceQuery()) != null) {
            processInstanceQuery = (ProcessInstanceQuery)processInstanceQueryDto.toQuery(this.getProcessEngine());
        }
        if ((historicProcessInstanceQueryDto = retriesDto.getHistoricProcessInstanceQuery()) != null) {
            historicProcessInstanceQuery = (HistoricProcessInstanceQuery)historicProcessInstanceQueryDto.toQuery(this.getProcessEngine());
        }
        return externalTaskService.updateRetries().externalTaskIds(externalTaskIds).processInstanceIds(processInstanceIds).externalTaskQuery(externalTaskQuery).processInstanceQuery(processInstanceQuery).historicProcessInstanceQuery(historicProcessInstanceQuery);
    }
}

