/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.batch.Batch;
import io.openbpm.bpm.engine.exception.NullValueException;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.management.SetJobRetriesByJobsAsyncBuilder;
import io.openbpm.bpm.engine.rest.JobRestService;
import io.openbpm.bpm.engine.rest.dto.CountResultDto;
import io.openbpm.bpm.engine.rest.dto.batch.BatchDto;
import io.openbpm.bpm.engine.rest.dto.runtime.JobDto;
import io.openbpm.bpm.engine.rest.dto.runtime.JobQueryDto;
import io.openbpm.bpm.engine.rest.dto.runtime.JobSuspensionStateDto;
import io.openbpm.bpm.engine.rest.dto.runtime.SetJobRetriesDto;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import io.openbpm.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import io.openbpm.bpm.engine.rest.sub.runtime.JobResource;
import io.openbpm.bpm.engine.rest.sub.runtime.impl.JobResourceImpl;
import io.openbpm.bpm.engine.rest.util.QueryUtil;
import io.openbpm.bpm.engine.runtime.Job;
import io.openbpm.bpm.engine.runtime.JobQuery;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.List;

public class JobRestServiceImpl
extends AbstractRestProcessEngineAware
implements JobRestService {
    public JobRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public JobResource getJob(String jobId) {
        return new JobResourceImpl(this.getProcessEngine(), jobId);
    }

    @Override
    public List<JobDto> getJobs(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        JobQueryDto queryDto = new JobQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryJobs(queryDto, firstResult, maxResults);
    }

    @Override
    public List<JobDto> queryJobs(JobQueryDto queryDto, Integer firstResult, Integer maxResults) {
        ProcessEngine engine = this.getProcessEngine();
        queryDto.setObjectMapper(this.getObjectMapper());
        JobQuery query = (JobQuery)queryDto.toQuery(engine);
        List<Job> matchingJobs = QueryUtil.list(query, firstResult, maxResults);
        ArrayList<JobDto> jobResults = new ArrayList<JobDto>();
        for (Job job : matchingJobs) {
            JobDto resultJob = JobDto.fromJob(job);
            jobResults.add(resultJob);
        }
        return jobResults;
    }

    @Override
    public CountResultDto getJobsCount(UriInfo uriInfo) {
        JobQueryDto queryDto = new JobQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryJobsCount(queryDto);
    }

    @Override
    public CountResultDto queryJobsCount(JobQueryDto queryDto) {
        ProcessEngine engine = this.getProcessEngine();
        queryDto.setObjectMapper(this.getObjectMapper());
        JobQuery query = (JobQuery)queryDto.toQuery(engine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }

    @Override
    public BatchDto setRetries(SetJobRetriesDto setJobRetriesDto) {
        try {
            EnsureUtil.ensureNotNull((String)"setJobRetriesDto", (Object)setJobRetriesDto);
            EnsureUtil.ensureNotNull((String)"retries", (Object)setJobRetriesDto.getRetries());
        }
        catch (NullValueException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        JobQuery jobQuery = null;
        if (setJobRetriesDto.getJobQuery() != null) {
            JobQueryDto jobQueryDto = setJobRetriesDto.getJobQuery();
            jobQueryDto.setObjectMapper(this.getObjectMapper());
            jobQuery = (JobQuery)jobQueryDto.toQuery(this.getProcessEngine());
        }
        try {
            SetJobRetriesByJobsAsyncBuilder builder = this.getProcessEngine().getManagementService().setJobRetriesByJobsAsync(setJobRetriesDto.getRetries().intValue()).jobIds(setJobRetriesDto.getJobIds()).jobQuery(jobQuery);
            if (setJobRetriesDto.isDueDateSet()) {
                builder.dueDate(setJobRetriesDto.getDueDate());
            }
            Batch batch = builder.executeAsync();
            return BatchDto.fromBatch(batch);
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    @Override
    public void updateSuspensionState(JobSuspensionStateDto dto) {
        if (dto.getJobId() != null) {
            String message = "Either jobDefinitionId, processInstanceId, processDefinitionId or processDefinitionKey can be set to update the suspension state.";
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, message);
        }
        dto.updateSuspensionState(this.getProcessEngine());
    }
}

