/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.batch.Batch;
import io.openbpm.bpm.engine.history.HistoricProcessInstanceQuery;
import io.openbpm.bpm.engine.rest.ModificationRestService;
import io.openbpm.bpm.engine.rest.dto.ModificationDto;
import io.openbpm.bpm.engine.rest.dto.batch.BatchDto;
import io.openbpm.bpm.engine.rest.dto.history.HistoricProcessInstanceQueryDto;
import io.openbpm.bpm.engine.rest.dto.runtime.ProcessInstanceQueryDto;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import io.openbpm.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import io.openbpm.bpm.engine.runtime.ModificationBuilder;
import io.openbpm.bpm.engine.runtime.ProcessInstanceQuery;
import jakarta.ws.rs.core.Response;
import java.util.List;

public class ModificationRestServiceImpl
extends AbstractRestProcessEngineAware
implements ModificationRestService {
    public ModificationRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public void executeModification(ModificationDto modificationExecutionDto) {
        try {
            this.createModificationBuilder(modificationExecutionDto).execute();
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    @Override
    public BatchDto executeModificationAsync(ModificationDto modificationExecutionDto) {
        Batch batch = null;
        try {
            batch = this.createModificationBuilder(modificationExecutionDto).executeAsync();
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        return BatchDto.fromBatch(batch);
    }

    private ModificationBuilder createModificationBuilder(ModificationDto dto) {
        HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto;
        ModificationBuilder builder = this.getProcessEngine().getRuntimeService().createModification(dto.getProcessDefinitionId());
        if (dto.getInstructions() != null && !dto.getInstructions().isEmpty()) {
            dto.applyTo(builder, this.getProcessEngine(), this.objectMapper);
        }
        List<String> processInstanceIds = dto.getProcessInstanceIds();
        builder.processInstanceIds(processInstanceIds);
        ProcessInstanceQueryDto processInstanceQueryDto = dto.getProcessInstanceQuery();
        if (processInstanceQueryDto != null) {
            ProcessInstanceQuery processInstanceQuery = (ProcessInstanceQuery)processInstanceQueryDto.toQuery(this.getProcessEngine());
            builder.processInstanceQuery(processInstanceQuery);
        }
        if ((historicProcessInstanceQueryDto = dto.getHistoricProcessInstanceQuery()) != null) {
            HistoricProcessInstanceQuery historicProcessInstanceQuery = (HistoricProcessInstanceQuery)historicProcessInstanceQueryDto.toQuery(this.getProcessEngine());
            builder.historicProcessInstanceQuery(historicProcessInstanceQuery);
        }
        if (dto.isSkipCustomListeners()) {
            builder.skipCustomListeners();
        }
        if (dto.isSkipIoMappings()) {
            builder.skipIoMappings();
        }
        if (dto.getAnnotation() != null) {
            builder.setAnnotation(dto.getAnnotation());
        }
        return builder;
    }
}

