/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.IdentityService;
import io.openbpm.bpm.engine.authorization.Permission;
import io.openbpm.bpm.engine.authorization.Permissions;
import io.openbpm.bpm.engine.authorization.Resource;
import io.openbpm.bpm.engine.authorization.Resources;
import io.openbpm.bpm.engine.identity.User;
import io.openbpm.bpm.engine.identity.UserQuery;
import io.openbpm.bpm.engine.rest.UserRestService;
import io.openbpm.bpm.engine.rest.dto.CountResultDto;
import io.openbpm.bpm.engine.rest.dto.ResourceOptionsDto;
import io.openbpm.bpm.engine.rest.dto.identity.UserDto;
import io.openbpm.bpm.engine.rest.dto.identity.UserProfileDto;
import io.openbpm.bpm.engine.rest.dto.identity.UserQueryDto;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import io.openbpm.bpm.engine.rest.impl.AbstractAuthorizedRestResource;
import io.openbpm.bpm.engine.rest.sub.identity.UserResource;
import io.openbpm.bpm.engine.rest.sub.identity.impl.UserResourceImpl;
import io.openbpm.bpm.engine.rest.util.PathUtil;
import io.openbpm.bpm.engine.rest.util.QueryUtil;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.List;

public class UserRestServiceImpl
extends AbstractAuthorizedRestResource
implements UserRestService {
    public UserRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, (Resource)Resources.USER, "*", objectMapper);
    }

    @Override
    public UserResource getUser(String id) {
        id = PathUtil.decodePathParam(id);
        return new UserResourceImpl(this.getProcessEngine().getName(), id, this.relativeRootResourcePath, this.getObjectMapper());
    }

    @Override
    public List<UserProfileDto> queryUsers(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        UserQueryDto queryDto = new UserQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryUsers(queryDto, firstResult, maxResults);
    }

    public List<UserProfileDto> queryUsers(UserQueryDto queryDto, Integer firstResult, Integer maxResults) {
        queryDto.setObjectMapper(this.getObjectMapper());
        UserQuery query = (UserQuery)queryDto.toQuery(this.getProcessEngine());
        List<User> resultList = QueryUtil.list(query, firstResult, maxResults);
        return UserProfileDto.fromUserList(resultList);
    }

    @Override
    public CountResultDto getUserCount(UriInfo uriInfo) {
        UserQueryDto queryDto = new UserQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.getUserCount(queryDto);
    }

    protected CountResultDto getUserCount(UserQueryDto queryDto) {
        UserQuery query = (UserQuery)queryDto.toQuery(this.getProcessEngine());
        long count = query.count();
        return new CountResultDto(count);
    }

    @Override
    public void createUser(UserDto userDto) {
        IdentityService identityService = this.getIdentityService();
        if (identityService.isReadOnly()) {
            throw new InvalidRequestException(Response.Status.FORBIDDEN, "Identity service implementation is read-only.");
        }
        UserProfileDto profile = userDto.getProfile();
        if (profile == null || profile.getId() == null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "request object must provide profile information with valid id.");
        }
        User newUser = identityService.newUser(profile.getId());
        profile.update(newUser);
        if (userDto.getCredentials() != null) {
            newUser.setPassword(userDto.getCredentials().getPassword());
        }
        identityService.saveUser(newUser);
    }

    @Override
    public ResourceOptionsDto availableOperations(UriInfo context) {
        IdentityService identityService = this.getIdentityService();
        UriBuilder baseUriBuilder = context.getBaseUriBuilder().path(this.relativeRootResourcePath).path("/user");
        ResourceOptionsDto resourceOptionsDto = new ResourceOptionsDto();
        URI baseUri = baseUriBuilder.build(new Object[0]);
        resourceOptionsDto.addReflexiveLink(baseUri, "GET", "list");
        URI countUri = baseUriBuilder.clone().path("/count").build(new Object[0]);
        resourceOptionsDto.addReflexiveLink(countUri, "GET", "count");
        if (!identityService.isReadOnly() && this.isAuthorized((Permission)Permissions.CREATE)) {
            URI createUri = baseUriBuilder.clone().path("/create").build(new Object[0]);
            resourceOptionsDto.addReflexiveLink(createUri, "POST", "create");
        }
        return resourceOptionsDto;
    }

    protected IdentityService getIdentityService() {
        return this.getProcessEngine().getIdentityService();
    }
}

