/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.HistoryService;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.batch.Batch;
import io.openbpm.bpm.engine.history.HistoricDecisionInstance;
import io.openbpm.bpm.engine.history.HistoricDecisionInstanceQuery;
import io.openbpm.bpm.engine.history.SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder;
import io.openbpm.bpm.engine.rest.dto.CountResultDto;
import io.openbpm.bpm.engine.rest.dto.batch.BatchDto;
import io.openbpm.bpm.engine.rest.dto.history.HistoricDecisionInstanceDto;
import io.openbpm.bpm.engine.rest.dto.history.HistoricDecisionInstanceQueryDto;
import io.openbpm.bpm.engine.rest.dto.history.batch.DeleteHistoricDecisionInstancesDto;
import io.openbpm.bpm.engine.rest.dto.history.batch.removaltime.SetRemovalTimeToHistoricDecisionInstancesDto;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import io.openbpm.bpm.engine.rest.history.HistoricDecisionInstanceRestService;
import io.openbpm.bpm.engine.rest.sub.history.HistoricDecisionInstanceResource;
import io.openbpm.bpm.engine.rest.sub.history.impl.HistoricDecisionInstanceResourceImpl;
import io.openbpm.bpm.engine.rest.util.QueryUtil;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class HistoricDecisionInstanceRestServiceImpl
implements HistoricDecisionInstanceRestService {
    protected ObjectMapper objectMapper;
    protected ProcessEngine processEngine;

    public HistoricDecisionInstanceRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    @Override
    public HistoricDecisionInstanceResource getHistoricDecisionInstance(String decisionInstanceId) {
        return new HistoricDecisionInstanceResourceImpl(this.processEngine, decisionInstanceId);
    }

    @Override
    public List<HistoricDecisionInstanceDto> getHistoricDecisionInstances(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        HistoricDecisionInstanceQueryDto queryHistoricDecisionInstanceDto = new HistoricDecisionInstanceQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryHistoricDecisionInstances(queryHistoricDecisionInstanceDto, firstResult, maxResults);
    }

    public List<HistoricDecisionInstanceDto> queryHistoricDecisionInstances(HistoricDecisionInstanceQueryDto queryDto, Integer firstResult, Integer maxResults) {
        HistoricDecisionInstanceQuery query = (HistoricDecisionInstanceQuery)queryDto.toQuery(this.processEngine);
        List<HistoricDecisionInstance> matchingHistoricDecisionInstances = QueryUtil.list(query, firstResult, maxResults);
        ArrayList<HistoricDecisionInstanceDto> historicDecisionInstanceDtoResults = new ArrayList<HistoricDecisionInstanceDto>();
        for (HistoricDecisionInstance historicDecisionInstance : matchingHistoricDecisionInstances) {
            HistoricDecisionInstanceDto resultHistoricDecisionInstanceDto = HistoricDecisionInstanceDto.fromHistoricDecisionInstance(historicDecisionInstance);
            historicDecisionInstanceDtoResults.add(resultHistoricDecisionInstanceDto);
        }
        return historicDecisionInstanceDtoResults;
    }

    @Override
    public CountResultDto getHistoricDecisionInstancesCount(UriInfo uriInfo) {
        HistoricDecisionInstanceQueryDto queryDto = new HistoricDecisionInstanceQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryHistoricDecisionInstancesCount(queryDto);
    }

    public CountResultDto queryHistoricDecisionInstancesCount(HistoricDecisionInstanceQueryDto queryDto) {
        HistoricDecisionInstanceQuery query = (HistoricDecisionInstanceQuery)queryDto.toQuery(this.processEngine);
        long count = query.count();
        return new CountResultDto(count);
    }

    @Override
    public BatchDto deleteAsync(DeleteHistoricDecisionInstancesDto dto) {
        HistoricDecisionInstanceQuery decisionInstanceQuery = null;
        if (dto.getHistoricDecisionInstanceQuery() != null) {
            decisionInstanceQuery = (HistoricDecisionInstanceQuery)dto.getHistoricDecisionInstanceQuery().toQuery(this.processEngine);
        }
        try {
            List<String> historicDecisionInstanceIds = dto.getHistoricDecisionInstanceIds();
            String deleteReason = dto.getDeleteReason();
            Batch batch = this.processEngine.getHistoryService().deleteHistoricDecisionInstancesAsync(historicDecisionInstanceIds, decisionInstanceQuery, deleteReason);
            return BatchDto.fromBatch(batch);
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    @Override
    public BatchDto setRemovalTimeAsync(SetRemovalTimeToHistoricDecisionInstancesDto dto) {
        HistoryService historyService = this.processEngine.getHistoryService();
        HistoricDecisionInstanceQuery historicDecisionInstanceQuery = null;
        if (dto.getHistoricDecisionInstanceQuery() != null) {
            historicDecisionInstanceQuery = (HistoricDecisionInstanceQuery)dto.getHistoricDecisionInstanceQuery().toQuery(this.processEngine);
        }
        SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder builder = historyService.setRemovalTimeToHistoricDecisionInstances();
        if (dto.isCalculatedRemovalTime()) {
            builder.calculatedRemovalTime();
        }
        Date removalTime = dto.getAbsoluteRemovalTime();
        if (dto.getAbsoluteRemovalTime() != null) {
            builder.absoluteRemovalTime(removalTime);
        }
        if (dto.isClearedRemovalTime()) {
            builder.clearedRemovalTime();
        }
        builder.byIds(dto.getHistoricDecisionInstanceIds());
        builder.byQuery(historicDecisionInstanceQuery);
        if (dto.isHierarchical()) {
            builder.hierarchical();
        }
        Batch batch = builder.executeAsync();
        return BatchDto.fromBatch(batch);
    }
}

