/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.mapper;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.Provider;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

@Provider
@Produces(value={"application/json", "application/hal+json"})
public class JacksonConfigurator
implements ContextResolver<ObjectMapper> {
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static String dateFormatString = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";

    public static ObjectMapper configureObjectMapper(ObjectMapper mapper) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateFormatString);
        mapper.setDateFormat((DateFormat)dateFormat);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.registerModule((Module)new JavaTimeModule());
        return mapper;
    }

    public ObjectMapper getContext(Class<?> clazz) {
        return JacksonConfigurator.configureObjectMapper(new ObjectMapper());
    }

    public static void setDateFormatString(String dateFormat) {
        dateFormatString = dateFormat;
    }

    public static String getDateFormatString() {
        return dateFormatString;
    }
}

