/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.security.auth.impl;

import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.rest.impl.AuthLogger;
import io.openbpm.bpm.engine.rest.impl.RestLogger;
import io.openbpm.bpm.engine.rest.security.auth.AuthenticationProvider;
import io.openbpm.bpm.engine.rest.security.auth.AuthenticationResult;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Base64;

public class HttpBasicAuthenticationProvider
implements AuthenticationProvider {
    protected static final String BASIC_AUTH_HEADER_PREFIX = "Basic ";
    private static final AuthLogger LOG = RestLogger.AUTH_LOGGER;

    @Override
    public AuthenticationResult extractAuthenticatedUser(HttpServletRequest request, ProcessEngine engine) {
        String authorizationHeader = request.getHeader("Authorization");
        if (authorizationHeader != null && authorizationHeader.startsWith(BASIC_AUTH_HEADER_PREFIX)) {
            String password;
            String decodedCredentials;
            String encodedCredentials = authorizationHeader.substring(BASIC_AUTH_HEADER_PREFIX.length());
            try {
                decodedCredentials = new String(Base64.getDecoder().decode(encodedCredentials));
            }
            catch (IllegalArgumentException e) {
                LOG.warnInvalidAuthHeader(e);
                return AuthenticationResult.unsuccessful();
            }
            int firstColonIndex = decodedCredentials.indexOf(":");
            if (firstColonIndex == -1) {
                return AuthenticationResult.unsuccessful();
            }
            String userName = decodedCredentials.substring(0, firstColonIndex);
            if (this.isAuthenticated(engine, userName, password = decodedCredentials.substring(firstColonIndex + 1))) {
                return AuthenticationResult.successful(userName);
            }
            return AuthenticationResult.unsuccessful(userName);
        }
        return AuthenticationResult.unsuccessful();
    }

    protected boolean isAuthenticated(ProcessEngine engine, String userName, String password) {
        return engine.getIdentityService().checkPassword(userName, password);
    }

    @Override
    public void augmentResponseByAuthenticationChallenge(HttpServletResponse response, ProcessEngine engine) {
        response.setHeader("WWW-Authenticate", "Basic realm=\"" + engine.getName() + "\"");
    }
}

