/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.sub.repository;

import io.openbpm.bpm.engine.rest.dto.HistoryTimeToLiveDto;
import io.openbpm.bpm.engine.rest.dto.StatisticsResultDto;
import io.openbpm.bpm.engine.rest.dto.VariableValueDto;
import io.openbpm.bpm.engine.rest.dto.batch.BatchDto;
import io.openbpm.bpm.engine.rest.dto.repository.CalledProcessDefinitionDto;
import io.openbpm.bpm.engine.rest.dto.repository.ProcessDefinitionDiagramDto;
import io.openbpm.bpm.engine.rest.dto.repository.ProcessDefinitionDto;
import io.openbpm.bpm.engine.rest.dto.repository.ProcessDefinitionSuspensionStateDto;
import io.openbpm.bpm.engine.rest.dto.runtime.ProcessInstanceDto;
import io.openbpm.bpm.engine.rest.dto.runtime.RestartProcessInstanceDto;
import io.openbpm.bpm.engine.rest.dto.runtime.StartProcessInstanceDto;
import io.openbpm.bpm.engine.rest.dto.task.FormDto;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import java.util.Map;

public interface ProcessDefinitionResource {
    @GET
    @Produces(value={"application/json"})
    public ProcessDefinitionDto getProcessDefinition();

    @GET
    @Path(value="/xml")
    @Produces(value={"application/json"})
    public ProcessDefinitionDiagramDto getProcessDefinitionBpmn20Xml();

    @GET
    @Path(value="/diagram")
    public Response getProcessDefinitionDiagram();

    @DELETE
    public Response deleteProcessDefinition(@QueryParam(value="cascade") boolean var1, @QueryParam(value="skipCustomListeners") boolean var2, @QueryParam(value="skipIoMappings") boolean var3);

    @POST
    @Path(value="/start")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ProcessInstanceDto startProcessInstance(@Context UriInfo var1, StartProcessInstanceDto var2);

    @POST
    @Path(value="/restart")
    @Consumes(value={"application/json"})
    public void restartProcessInstance(RestartProcessInstanceDto var1);

    @POST
    @Path(value="/restart-async")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public BatchDto restartProcessInstanceAsync(RestartProcessInstanceDto var1);

    @POST
    @Path(value="/submit-form")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ProcessInstanceDto submitForm(@Context UriInfo var1, StartProcessInstanceDto var2);

    @GET
    @Path(value="/statistics")
    @Produces(value={"application/json"})
    public List<StatisticsResultDto> getActivityStatistics(@QueryParam(value="failedJobs") Boolean var1, @QueryParam(value="incidents") Boolean var2, @QueryParam(value="incidentsForType") String var3);

    @GET
    @Path(value="/startForm")
    @Produces(value={"application/json"})
    public FormDto getStartForm();

    @GET
    @Path(value="/deployed-start-form")
    public Response getDeployedStartForm();

    @GET
    @Path(value="/rendered-form")
    @Produces(value={"application/xhtml+xml"})
    public Response getRenderedForm();

    @PUT
    @Path(value="/suspended")
    @Consumes(value={"application/json"})
    public void updateSuspensionState(ProcessDefinitionSuspensionStateDto var1);

    @PUT
    @Path(value="/history-time-to-live")
    @Consumes(value={"application/json"})
    public void updateHistoryTimeToLive(HistoryTimeToLiveDto var1);

    @GET
    @Path(value="/form-variables")
    @Produces(value={"application/json"})
    public Map<String, VariableValueDto> getFormVariables(@QueryParam(value="variableNames") String var1, @QueryParam(value="deserializeValues") @DefaultValue(value="true") boolean var2);

    @GET
    @Path(value="/static-called-process-definitions")
    @Produces(value={"application/json"})
    public List<CalledProcessDefinitionDto> getStaticCalledProcessDefinitions();
}

