/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.sub.runtime.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.CaseService;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.exception.NotAllowedException;
import io.openbpm.bpm.engine.exception.NotFoundException;
import io.openbpm.bpm.engine.exception.NotValidException;
import io.openbpm.bpm.engine.rest.dto.runtime.CaseExecutionTriggerDto;
import io.openbpm.bpm.engine.rest.dto.runtime.CaseInstanceDto;
import io.openbpm.bpm.engine.rest.dto.runtime.TriggerVariableValueDto;
import io.openbpm.bpm.engine.rest.dto.runtime.VariableNameDto;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import io.openbpm.bpm.engine.rest.exception.RestException;
import io.openbpm.bpm.engine.rest.sub.VariableResource;
import io.openbpm.bpm.engine.rest.sub.runtime.CaseInstanceResource;
import io.openbpm.bpm.engine.rest.sub.runtime.impl.CaseExecutionVariablesResource;
import io.openbpm.bpm.engine.runtime.CaseExecutionCommandBuilder;
import io.openbpm.bpm.engine.runtime.CaseInstance;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Map;

public class CaseInstanceResourceImpl
implements CaseInstanceResource {
    private static final String TRANSITION_COMPLETE = "complete";
    private static final String TRANSITION_CLOSE = "close";
    private static final String TRANSITION_TERMINATE = "terminate";
    protected ProcessEngine engine;
    protected String caseInstanceId;
    protected ObjectMapper objectMapper;

    public CaseInstanceResourceImpl(ProcessEngine engine, String caseInstanceId, ObjectMapper objectMapper) {
        this.engine = engine;
        this.caseInstanceId = caseInstanceId;
        this.objectMapper = objectMapper;
    }

    @Override
    public CaseInstanceDto getCaseInstance() {
        CaseService caseService = this.engine.getCaseService();
        CaseInstance instance = (CaseInstance)caseService.createCaseInstanceQuery().caseInstanceId(this.caseInstanceId).singleResult();
        if (instance == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Case instance with id " + this.caseInstanceId + " does not exist.");
        }
        return CaseInstanceDto.fromCaseInstance(instance);
    }

    @Override
    public void complete(CaseExecutionTriggerDto triggerDto) {
        try {
            CaseService caseService = this.engine.getCaseService();
            CaseExecutionCommandBuilder commandBuilder = caseService.withCaseExecution(this.caseInstanceId);
            this.initializeCommand(commandBuilder, triggerDto, TRANSITION_COMPLETE);
            commandBuilder.complete();
        }
        catch (NotFoundException e) {
            throw this.createInvalidRequestException(TRANSITION_COMPLETE, Response.Status.NOT_FOUND, (ProcessEngineException)((Object)e));
        }
        catch (NotValidException e) {
            throw this.createInvalidRequestException(TRANSITION_COMPLETE, Response.Status.BAD_REQUEST, (ProcessEngineException)((Object)e));
        }
        catch (NotAllowedException e) {
            throw this.createInvalidRequestException(TRANSITION_COMPLETE, Response.Status.FORBIDDEN, (ProcessEngineException)((Object)e));
        }
        catch (ProcessEngineException e) {
            throw this.createRestException(TRANSITION_COMPLETE, Response.Status.INTERNAL_SERVER_ERROR, e);
        }
    }

    @Override
    public void close(CaseExecutionTriggerDto triggerDto) {
        try {
            CaseService caseService = this.engine.getCaseService();
            CaseExecutionCommandBuilder commandBuilder = caseService.withCaseExecution(this.caseInstanceId);
            this.initializeCommand(commandBuilder, triggerDto, TRANSITION_CLOSE);
            commandBuilder.close();
        }
        catch (NotFoundException e) {
            throw this.createInvalidRequestException(TRANSITION_CLOSE, Response.Status.NOT_FOUND, (ProcessEngineException)((Object)e));
        }
        catch (NotValidException e) {
            throw this.createInvalidRequestException(TRANSITION_CLOSE, Response.Status.BAD_REQUEST, (ProcessEngineException)((Object)e));
        }
        catch (NotAllowedException e) {
            throw this.createInvalidRequestException(TRANSITION_CLOSE, Response.Status.FORBIDDEN, (ProcessEngineException)((Object)e));
        }
        catch (ProcessEngineException e) {
            throw this.createRestException(TRANSITION_CLOSE, Response.Status.INTERNAL_SERVER_ERROR, e);
        }
    }

    @Override
    public void terminate(CaseExecutionTriggerDto triggerDto) {
        try {
            CaseService caseService = this.engine.getCaseService();
            CaseExecutionCommandBuilder commandBuilder = caseService.withCaseExecution(this.caseInstanceId);
            this.initializeCommand(commandBuilder, triggerDto, TRANSITION_TERMINATE);
            commandBuilder.terminate();
        }
        catch (NotFoundException e) {
            throw this.createInvalidRequestException(TRANSITION_TERMINATE, Response.Status.NOT_FOUND, (ProcessEngineException)((Object)e));
        }
        catch (NotValidException e) {
            throw this.createInvalidRequestException(TRANSITION_TERMINATE, Response.Status.BAD_REQUEST, (ProcessEngineException)((Object)e));
        }
        catch (NotAllowedException e) {
            throw this.createInvalidRequestException(TRANSITION_TERMINATE, Response.Status.FORBIDDEN, (ProcessEngineException)((Object)e));
        }
        catch (ProcessEngineException e) {
            throw this.createRestException(TRANSITION_TERMINATE, Response.Status.INTERNAL_SERVER_ERROR, e);
        }
    }

    protected InvalidRequestException createInvalidRequestException(String transition, Response.Status status, ProcessEngineException cause) {
        String errorMessage = "Cannot %s case instance %s: %s".formatted(transition, this.caseInstanceId, cause.getMessage());
        return new InvalidRequestException(status, (Exception)((Object)cause), errorMessage);
    }

    protected RestException createRestException(String transition, Response.Status status, ProcessEngineException cause) {
        String errorMessage = "Cannot %s case instance %s: %s".formatted(transition, this.caseInstanceId, cause.getMessage());
        return new RestException(status, (Exception)((Object)cause), errorMessage);
    }

    protected void initializeCommand(CaseExecutionCommandBuilder commandBuilder, CaseExecutionTriggerDto triggerDto, String transition) {
        List<VariableNameDto> deletions;
        Map<String, TriggerVariableValueDto> variables = triggerDto.getVariables();
        if (variables != null && !variables.isEmpty()) {
            this.initializeCommandWithVariables(commandBuilder, variables, transition);
        }
        if ((deletions = triggerDto.getDeletions()) != null && !deletions.isEmpty()) {
            this.initializeCommandWithDeletions(commandBuilder, deletions, transition);
        }
    }

    protected void initializeCommandWithVariables(CaseExecutionCommandBuilder commandBuilder, Map<String, TriggerVariableValueDto> variables, String transition) {
        for (Map.Entry<String, TriggerVariableValueDto> vars : variables.entrySet()) {
            String variableName = vars.getKey();
            try {
                TriggerVariableValueDto variableValue = vars.getValue();
                if (variableValue.isLocal()) {
                    commandBuilder.setVariableLocal(variableName, (Object)variableValue.toTypedValue(this.engine, this.objectMapper));
                    continue;
                }
                commandBuilder.setVariable(variableName, (Object)variableValue.toTypedValue(this.engine, this.objectMapper));
            }
            catch (RestException e) {
                String errorMessage = "Cannot %s case instance %s due to invalid variable %s: %s".formatted(transition, this.caseInstanceId, variableName, e.getMessage());
                throw new RestException(e.getStatus(), e, errorMessage);
            }
        }
    }

    protected void initializeCommandWithDeletions(CaseExecutionCommandBuilder commandBuilder, List<VariableNameDto> deletions, String transition) {
        for (VariableNameDto variableName : deletions) {
            if (variableName.isLocal()) {
                commandBuilder.removeVariableLocal(variableName.getName());
                continue;
            }
            commandBuilder.removeVariable(variableName.getName());
        }
    }

    @Override
    public VariableResource getVariablesResource() {
        return new CaseExecutionVariablesResource(this.engine, this.caseInstanceId, this.objectMapper);
    }
}

