/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.impl.juel;

import io.openbpm.bpm.impl.juel.AstNode;
import io.openbpm.bpm.impl.juel.Bindings;
import io.openbpm.bpm.impl.juel.IdentifierNode;
import io.openbpm.bpm.impl.juel.LocalMessages;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.MethodInfo;
import jakarta.el.MethodNotFoundException;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.ValueExpression;
import jakarta.el.ValueReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

public class AstIdentifier
extends AstNode
implements IdentifierNode {
    private static final String ERROR_IDENTIFIER_METHOD_ACCESS = "error.identifier.method.access";
    private static final String ERROR_IDENTIFIER_METHOD_INVOCATION = "error.identifier.method.invocation";
    private static final String ERROR_IDENTIFIER_METHOD_NOTAMETHOD = "error.identifier.method.notamethod";
    private static final String ERROR_IDENTIFIER_METHOD_NOTFOUND = "error.identifier.method.notfound";
    private static final String ERROR_IDENTIFIER_PROPERTY_NOTFOUND = "error.identifier.property.notfound";
    private final String name;
    private final int index;

    public AstIdentifier(String name, int index) {
        this.name = name;
        this.index = index;
    }

    @Override
    public Class<?> getType(Bindings bindings, ELContext context) {
        ValueExpression expression = bindings.getVariable(this.index);
        if (expression != null) {
            return expression.getType(context);
        }
        context.setPropertyResolved(false);
        Class result = context.getELResolver().getType(context, null, (Object)this.name);
        if (!context.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get(ERROR_IDENTIFIER_PROPERTY_NOTFOUND, this.name));
        }
        return result;
    }

    @Override
    public boolean isLeftValue() {
        return true;
    }

    @Override
    public boolean isMethodInvocation() {
        return false;
    }

    @Override
    public boolean isLiteralText() {
        return false;
    }

    @Override
    public ValueReference getValueReference(Bindings bindings, ELContext context) {
        ValueExpression expression = bindings.getVariable(this.index);
        if (expression != null) {
            return expression.getValueReference(context);
        }
        return new ValueReference(null, (Object)this.name);
    }

    @Override
    public Object eval(Bindings bindings, ELContext context) {
        ValueExpression expression = bindings.getVariable(this.index);
        if (expression != null) {
            return expression.getValue(context);
        }
        context.setPropertyResolved(false);
        Object result = context.getELResolver().getValue(context, null, (Object)this.name);
        if (!context.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get(ERROR_IDENTIFIER_PROPERTY_NOTFOUND, this.name));
        }
        return result;
    }

    @Override
    public void setValue(Bindings bindings, ELContext context, Object value) {
        ValueExpression expression = bindings.getVariable(this.index);
        if (expression != null) {
            expression.setValue(context, value);
            return;
        }
        context.setPropertyResolved(false);
        context.getELResolver().setValue(context, null, (Object)this.name, value);
        if (!context.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get(ERROR_IDENTIFIER_PROPERTY_NOTFOUND, this.name));
        }
    }

    @Override
    public boolean isReadOnly(Bindings bindings, ELContext context) {
        ValueExpression expression = bindings.getVariable(this.index);
        if (expression != null) {
            return expression.isReadOnly(context);
        }
        context.setPropertyResolved(false);
        boolean result = context.getELResolver().isReadOnly(context, null, (Object)this.name);
        if (!context.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get(ERROR_IDENTIFIER_PROPERTY_NOTFOUND, this.name));
        }
        return result;
    }

    protected Method getMethod(Bindings bindings, ELContext context, Class<?> returnType, Class<?>[] paramTypes) {
        Object value = this.eval(bindings, context);
        if (value == null) {
            throw new MethodNotFoundException(LocalMessages.get(ERROR_IDENTIFIER_METHOD_NOTFOUND, this.name));
        }
        if (value instanceof Method) {
            Method method = (Method)value;
            if (returnType != null && !returnType.isAssignableFrom(method.getReturnType())) {
                throw new MethodNotFoundException(LocalMessages.get(ERROR_IDENTIFIER_METHOD_NOTFOUND, this.name));
            }
            if (!Arrays.equals(method.getParameterTypes(), paramTypes)) {
                throw new MethodNotFoundException(LocalMessages.get(ERROR_IDENTIFIER_METHOD_NOTFOUND, this.name));
            }
            return method;
        }
        throw new MethodNotFoundException(LocalMessages.get(ERROR_IDENTIFIER_METHOD_NOTAMETHOD, this.name, value.getClass()));
    }

    @Override
    public MethodInfo getMethodInfo(Bindings bindings, ELContext context, Class<?> returnType, Class<?>[] paramTypes) {
        Method method = this.getMethod(bindings, context, returnType, paramTypes);
        return new MethodInfo(method.getName(), method.getReturnType(), (Class[])paramTypes);
    }

    @Override
    public Object invoke(Bindings bindings, ELContext context, Class<?> returnType, Class<?>[] paramTypes, Object[] params) {
        Method method = this.getMethod(bindings, context, returnType, paramTypes);
        try {
            return method.invoke(null, params);
        }
        catch (IllegalAccessException e) {
            throw new ELException(LocalMessages.get(ERROR_IDENTIFIER_METHOD_ACCESS, this.name));
        }
        catch (IllegalArgumentException e) {
            throw new ELException(LocalMessages.get(ERROR_IDENTIFIER_METHOD_INVOCATION, this.name, e));
        }
        catch (InvocationTargetException e) {
            throw new ELException(LocalMessages.get(ERROR_IDENTIFIER_METHOD_INVOCATION, this.name, e.getCause()));
        }
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void appendStructure(StringBuilder b, Bindings bindings) {
        b.append(bindings != null && bindings.isVariableBound(this.index) ? "<var>" : this.name);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getCardinality() {
        return 0;
    }

    @Override
    public AstNode getChild(int i) {
        return null;
    }
}

