/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.impl.juel;

import io.openbpm.bpm.impl.juel.AstNode;
import io.openbpm.bpm.impl.juel.Bindings;
import io.openbpm.bpm.impl.juel.LocalMessages;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.MethodInfo;
import jakarta.el.MethodNotFoundException;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.ValueReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class AstProperty
extends AstNode {
    private static final String ERROR_PROPERTY_BASE_NULL = "error.property.base.null";
    private static final String ERROR_PROPERTY_METHOD_ACCESS = "error.property.method.access";
    private static final String ERROR_PROPERTY_METHOD_NOTFOUND = "error.property.method.notfound";
    private static final String ERROR_PROPERTY_METHOD_INVOCATION = "error.property.method.invocation";
    private static final String ERROR_PROPERTY_PROPERTY_NOTFOUND = "error.property.property.notfound";
    private static final String ERROR_VALUE_SET_RVALUE = "error.value.set.rvalue";
    protected final AstNode prefix;
    protected final boolean lvalue;
    protected final boolean strict;

    protected AstProperty(AstNode prefix, boolean lvalue, boolean strict) {
        this.prefix = prefix;
        this.lvalue = lvalue;
        this.strict = strict;
    }

    protected abstract Object getProperty(Bindings var1, ELContext var2) throws ELException;

    protected AstNode getPrefix() {
        return this.prefix;
    }

    @Override
    public ValueReference getValueReference(Bindings bindings, ELContext context) {
        return new ValueReference(this.prefix.eval(bindings, context), this.getProperty(bindings, context));
    }

    @Override
    public Object eval(Bindings bindings, ELContext context) {
        Object base = this.prefix.eval(bindings, context);
        if (base == null) {
            return null;
        }
        Object property = this.getProperty(bindings, context);
        if (property == null && this.strict) {
            return null;
        }
        context.setPropertyResolved(false);
        Object result = context.getELResolver().getValue(context, base, property);
        if (!context.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get(ERROR_PROPERTY_PROPERTY_NOTFOUND, property, base));
        }
        return result;
    }

    @Override
    public final boolean isLiteralText() {
        return false;
    }

    @Override
    public final boolean isLeftValue() {
        return this.lvalue;
    }

    @Override
    public boolean isMethodInvocation() {
        return false;
    }

    @Override
    public Class<?> getType(Bindings bindings, ELContext context) {
        if (!this.lvalue) {
            return null;
        }
        Object base = this.prefix.eval(bindings, context);
        if (base == null) {
            throw new PropertyNotFoundException(LocalMessages.get(ERROR_PROPERTY_BASE_NULL, this.prefix));
        }
        Object property = this.getProperty(bindings, context);
        if (property == null && this.strict) {
            throw new PropertyNotFoundException(LocalMessages.get(ERROR_PROPERTY_PROPERTY_NOTFOUND, "null", base));
        }
        context.setPropertyResolved(false);
        Class result = context.getELResolver().getType(context, base, property);
        if (!context.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get(ERROR_PROPERTY_PROPERTY_NOTFOUND, property, base));
        }
        return result;
    }

    @Override
    public boolean isReadOnly(Bindings bindings, ELContext context) throws ELException {
        if (!this.lvalue) {
            return true;
        }
        Object base = this.prefix.eval(bindings, context);
        if (base == null) {
            throw new PropertyNotFoundException(LocalMessages.get(ERROR_PROPERTY_BASE_NULL, this.prefix));
        }
        Object property = this.getProperty(bindings, context);
        if (property == null && this.strict) {
            throw new PropertyNotFoundException(LocalMessages.get(ERROR_PROPERTY_PROPERTY_NOTFOUND, "null", base));
        }
        context.setPropertyResolved(false);
        boolean result = context.getELResolver().isReadOnly(context, base, property);
        if (!context.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get(ERROR_PROPERTY_PROPERTY_NOTFOUND, property, base));
        }
        return result;
    }

    @Override
    public void setValue(Bindings bindings, ELContext context, Object value) throws ELException {
        if (!this.lvalue) {
            throw new ELException(LocalMessages.get(ERROR_VALUE_SET_RVALUE, this.getStructuralId(bindings)));
        }
        Object base = this.prefix.eval(bindings, context);
        if (base == null) {
            throw new PropertyNotFoundException(LocalMessages.get(ERROR_PROPERTY_BASE_NULL, this.prefix));
        }
        Object property = this.getProperty(bindings, context);
        if (property == null && this.strict) {
            throw new PropertyNotFoundException(LocalMessages.get(ERROR_PROPERTY_PROPERTY_NOTFOUND, "null", base));
        }
        context.setPropertyResolved(false);
        context.getELResolver().setValue(context, base, property, value);
        if (!context.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get(ERROR_PROPERTY_PROPERTY_NOTFOUND, property, base));
        }
    }

    protected Method findMethod(String name, Class<?> clazz, Class<?> returnType, Class<?>[] paramTypes) {
        Method method = null;
        try {
            method = clazz.getMethod(name, paramTypes);
        }
        catch (NoSuchMethodException e) {
            throw new MethodNotFoundException(LocalMessages.get(ERROR_PROPERTY_METHOD_NOTFOUND, name, clazz));
        }
        if (returnType != null && !returnType.isAssignableFrom(method.getReturnType())) {
            throw new MethodNotFoundException(LocalMessages.get(ERROR_PROPERTY_METHOD_NOTFOUND, name, clazz));
        }
        return method;
    }

    @Override
    public MethodInfo getMethodInfo(Bindings bindings, ELContext context, Class<?> returnType, Class<?>[] paramTypes) {
        Object base = this.prefix.eval(bindings, context);
        if (base == null) {
            throw new PropertyNotFoundException(LocalMessages.get(ERROR_PROPERTY_BASE_NULL, this.prefix));
        }
        Object property = this.getProperty(bindings, context);
        if (property == null && this.strict) {
            throw new PropertyNotFoundException(LocalMessages.get(ERROR_PROPERTY_METHOD_NOTFOUND, "null", base));
        }
        String name = bindings.convert(property, String.class);
        Method method = this.findMethod(name, base.getClass(), returnType, paramTypes);
        return new MethodInfo(method.getName(), method.getReturnType(), (Class[])paramTypes);
    }

    @Override
    public Object invoke(Bindings bindings, ELContext context, Class<?> returnType, Class<?>[] paramTypes, Object[] paramValues) {
        Object base = this.prefix.eval(bindings, context);
        if (base == null) {
            throw new PropertyNotFoundException(LocalMessages.get(ERROR_PROPERTY_BASE_NULL, this.prefix));
        }
        Object property = this.getProperty(bindings, context);
        if (property == null && this.strict) {
            throw new PropertyNotFoundException(LocalMessages.get(ERROR_PROPERTY_METHOD_NOTFOUND, "null", base));
        }
        String name = bindings.convert(property, String.class);
        Method method = this.findMethod(name, base.getClass(), returnType, paramTypes);
        try {
            return method.invoke(base, paramValues);
        }
        catch (IllegalAccessException e) {
            throw new ELException(LocalMessages.get(ERROR_PROPERTY_METHOD_ACCESS, name, base.getClass()));
        }
        catch (IllegalArgumentException e) {
            throw new ELException(LocalMessages.get(ERROR_PROPERTY_METHOD_INVOCATION, name, base.getClass()), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ELException(LocalMessages.get(ERROR_PROPERTY_METHOD_INVOCATION, name, base.getClass()), e.getCause());
        }
    }

    @Override
    public AstNode getChild(int i) {
        return i == 0 ? this.prefix : null;
    }
}

