/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.templateengines;

import freemarker.template.Configuration;
import freemarker.template.Template;
import io.openbpm.templateengines.FreeMarkerCompiledScript;
import io.openbpm.templateengines.FreeMarkerScriptEngineFactory;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

public class FreeMarkerScriptEngine
extends AbstractScriptEngine
implements Compilable {
    protected ScriptEngineFactory scriptEngineFactory;
    protected Configuration configuration;

    public FreeMarkerScriptEngine() {
        this((ScriptEngineFactory)null);
    }

    public FreeMarkerScriptEngine(ScriptEngineFactory scriptEngineFactory) {
        this.scriptEngineFactory = scriptEngineFactory;
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        return this.eval((Reader)new StringReader(script), context);
    }

    @Override
    public Object eval(Reader script, ScriptContext context) throws ScriptException {
        this.initConfiguration();
        String filename = this.getFilename(context);
        StringWriter writer = new StringWriter();
        Bindings bindings = context.getBindings(100);
        try {
            Template template = new Template(filename, script, this.configuration);
            template.process((Object)bindings, (Writer)writer);
            ((Writer)writer).flush();
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        return ((Object)writer).toString();
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public synchronized ScriptEngineFactory getFactory() {
        if (this.scriptEngineFactory == null) {
            this.scriptEngineFactory = new FreeMarkerScriptEngineFactory();
        }
        return this.scriptEngineFactory;
    }

    public synchronized void initConfiguration() {
        if (this.configuration == null) {
            this.configuration = new Configuration(Configuration.VERSION_2_3_29);
        }
    }

    protected String getFilename(ScriptContext context) {
        String filename = (String)context.getAttribute("javax.script.filename");
        if (filename != null) {
            return filename;
        }
        return "unknown";
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        return this.compile(new StringReader(script));
    }

    @Override
    public CompiledScript compile(Reader script) throws ScriptException {
        this.initConfiguration();
        return new FreeMarkerCompiledScript((ScriptEngine)this, script, this.configuration);
    }
}

