/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.spin.plugin.impl;

import io.openbpm.bpm.engine.impl.variable.serializer.ValueFields;
import io.openbpm.bpm.engine.variable.impl.value.UntypedValueImpl;
import io.openbpm.spin.DataFormats;
import io.openbpm.spin.json.SpinJsonNode;
import io.openbpm.spin.plugin.impl.SpinValueSerializer;
import io.openbpm.spin.plugin.variable.SpinValues;
import io.openbpm.spin.plugin.variable.type.SpinValueType;
import io.openbpm.spin.plugin.variable.value.SpinValue;
import io.openbpm.spin.plugin.variable.value.impl.JsonValueImpl;
import io.openbpm.spin.spi.DataFormat;

public class JsonValueSerializer
extends SpinValueSerializer {
    public JsonValueSerializer(DataFormat<SpinJsonNode> dataFormat) {
        super(SpinValueType.JSON, dataFormat, "json");
    }

    public JsonValueSerializer() {
        this((DataFormat<SpinJsonNode>)DataFormats.json());
    }

    public SpinValue convertToTypedValue(UntypedValueImpl untypedValue) {
        return (SpinValue)SpinValues.jsonValue((SpinJsonNode)untypedValue.getValue()).create();
    }

    protected SpinValue createDeserializedValue(Object deserializedObject, String serializedStringValue, ValueFields valueFields, boolean asTransientValue) {
        SpinJsonNode value = (SpinJsonNode)deserializedObject;
        JsonValueImpl jsonValue = new JsonValueImpl(value, serializedStringValue, this.dataFormat.getName(), true);
        jsonValue.setTransient(asTransientValue);
        return jsonValue;
    }

    protected SpinValue createSerializedValue(String serializedStringValue, ValueFields valueFields, boolean asTransientValue) {
        JsonValueImpl jsonValue = new JsonValueImpl(serializedStringValue, this.serializationDataFormat);
        jsonValue.setTransient(asTransientValue);
        return jsonValue;
    }
}

